
/**
 * @author Harsh Raghuwanshi 
 */
Ext.define('Academia.view.admission.applicationOwnerSetup.StcAdmEditWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.stcadmeditwindow',
	modal: true,
	frame: true,
	title:getCommonTranslation('CHANGE_APPLICATION_OWNER'),
	items: [{		
    xtype: 'form',
    defaults:{
    	labelAlign:'top',
    	width:226
    },
    standardSubmit: false,
    plugins:"formlabelrequired",    
    items:[{
    	xtype: 'customcombobox',
    	fieldLabel: getCommonTranslation('USER_CODE_NAME'),
    	itemId: 'userApplicationOwnerId',
    	name: 'userApplicationOwnerId',
    	store:Ext.create('Academia.store.admission.applicationOwnerSetup.StoAdmAppOwnerUserFindAllStore'),
		valueField: 'id',
		displayField: 'valueCode',
		queryParam:'name',
		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		enableKeyEvents  : 'true',
		minChars:3,
		typeAhead:false,
		hideTrigger:false,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		triggerAction: '',
		allowBlank:false,
		enforceMaxLength : true,
    	listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{code}/{nameToBePrinted}' +
				'</div>';
			}
		}
    },
	{
		xtype : 'fieldcontainer',
		width : '100%',
		cls : 'windowBtnPos',
		items : [ {
			xtype : 'button',
			action : 'Submit',
			text : getCommonTranslation('SAVE'),
			itemId : 'appOwnerSubmitButtonId',
			formBind: true,
			name: 'appOwnerSubmitButtonId',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
		}, {
			xtype : 'button',
			itemId : 'appOwnerCancelButtonId',
			text : getCommonTranslation('CANCEL'),
			ui : 'CustomBtnCancel',
			scale : CONSTANTS.BUTTONSIZE
		} ]
	}]
	}]
});
