/**
 * @author trupti.paoneker
 * 
 * This component is used for to show window with confirmed or withdrawn status of Admission details. 
 * 
 */
Ext.define('Academia.view.admission.applications.admissionAndMidTermAdmission.ConfirmOrWithdrawAdmissionWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.confirmorwithdrawadmissionwindow',
    modal: true,
    resizable: false,
    title: getAdmissionTranslation('TRIAL_ADMISSION_CLOSURE'), //Trial Admission Closure
    margin: 0,
    items: [{
        xtype: 'form',
        itemId: 'confirmorwithdrawadmissionForm',
        plugins: "formlabelrequired",
        standardSubmit: false,
        items: [{
            xtype: 'hidden',
            itemId: 'confirmorwithdrawadmission_hidden_field',
            name: 'id'
        }, {
            xtype: 'hidden',
            name: 'version'
        }, {
            xtype: 'fieldcontainer',
            layout: {
                type: 'vbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                xtype: 'radiogroup',
                fieldLabel: getAdmissionTranslation('CONCLUSION_TRIAL_ADM'), //Conclusion of Trial Admission 
                name: 'RADIO_Btn',
                //allowBlank:false,
                layout: {
                    type: 'hbox'
                },
                items: [{
                    boxLabel: getAdmissionTranslation('CONFIRMED'), //Confirmed
                    name: 'conclusion',
                    inputValue: 'CONFIRMED',
                    checked: true
                }, {
                    boxLabel: getAdmissionTranslation('WITHDRAWN'), //Withdrawn
                    name: 'conclusion',
                    inputValue: 'WITHDRAWN'
                }]
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            items: [{
                fieldLabel: getAdmissionTranslation('REASON'), //Reason
                xtype: 'textarea',
                itemId: 'trialAdmissionClosureReason',
                name: 'trialAdmissionClosureReason',
                labelAlign: 'top',
                allowBlank: false,
                width: 450
            }]
          }, {
        xtype: 'fieldcontainer',
        width: '100%',
        
        items: [{
	            xtype: 'button',
	            itemId: 'btnSaveConfirmOrWithdrawAdmForm',
	            text: getCommonTranslation('SAVE'), //Save
	            ui: 'CustomBtnSubmit',
	            scale: CONSTANTS.BUTTONSIZE,
	            formBind: true
	        }, {
	            xtype: 'button',
	            itemId: 'btnCancelConfirmOrWithdrawAdmForm',
	            text: getCommonTranslation('CANCEL'), //Cancel
	            ui: 'CustomBtnCancel',
	            scale: CONSTANTS.BUTTONSIZE
	        }]
          }]
    }]
});