/**
 * @author Trupti.Paoneker
 *
 * This component is used for to show Other courses in grid details.
 */
Ext.define('Academia.view.admission.applications.admissionAndMidTermAdmission.MidTermOtherCoursesGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.midtermothercoursesgrid',
    title: getAdmissionTranslation('OTHER_COURSES_COMPLETED'), //Other Courses Completed
    border: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    initComponent: function() {    	     
     	var grid=this;
     	var store=Ext.create('Academia.store.admission.applications.admissionAndMidTermAdmission.MidTermAdmOtherCourseGridStore');
     	Ext.apply(this, {
             store: store        
         });
         this.callParent(arguments);
         var custompagingtoolbar=grid.down('custompagingtoolbar');
         if(custompagingtoolbar){
         	custompagingtoolbar.bindStore(store);        	
         }
     },
    columns: [{
        header: getAdmissionTranslation('COURSE_NAME'),  //Course Name 
        dataIndex: 'courseName',        
        flex: .2
    }, {
        header: getCommonTranslation('DESCRIPTION'), //Description
        dataIndex: 'description',        
        flex: .2
    }, {
        header: getAdmissionTranslation('MARKS'), //Marks
        dataIndex: 'marks',        
        flex: .2
    }, {
        header: getAdmissionTranslation('GRADES'), //Grades
        dataIndex: 'grade',        
        flex: .2
    }],
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'), //Add 
        glyph: ICONGLYPH.ADDGLYPH,
        hasDisableForProfileViewMode:true
        //text : getCommonTranslation('ADD')
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'), //Edit
        glyph: ICONGLYPH.EDITGLYPH,
        hasDisableForProfileViewMode:true
        //text : getCommonTranslation('EDIT')
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'), //View
        iconCls: 'view-icon'
        //text : getCommonTranslation('VIEW')
    },{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),//Delete 
		glyph: ICONGLYPH.DELETEGLYPH,
        hasDisableForProfileViewMode:true
		//text : getCommonTranslation('DELETE')
	}],
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],           
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }]
    }]
});