/**
 * @author Vyabha Thakur
 */
Ext.define('Academia.view.admission.applications.applicantProfileBase.DocumentAndNotesUrlGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.documentandnotesurlgrid',
    store : 'admission.applications.applicantProfileBase.DocumentAndNotesUrlGridStore',
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	tbar: [{
        xtype: 'button',
        itemId: 'btnEdit',
		disabled:true,
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    },{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH		
	}],
	columns :[{
		header : getCommonTranslation('DOCUMENT_URL_NAME'),
		dataIndex : 'name',
		flex:1,
		renderer:function(value,rec){
			var value1=!isNullOrEmpty(value)?value:rec.record.data.name;
            var newPath=rec.record.data.path;    
            var val=!isNullOrEmpty(value1)?value1:newPath;
            return "<a href="+newPath+" target='_blank'>"+val;
		}
	}]

});

