/**
 * @author Amit G
 * 
 */
Ext.define('Academia.view.admission.applications.applicationBase.AdmissionConditionsReviewAdmForm', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.admissionconditionsreviewadmform',
	title: getAdmissionTranslation('ADMISSION_CONDITIONS'),
	autoScroll: true,
	frame: true,
	modal: true,
	method: 'POST',
	plugins: "formlabelrequired",
	items: [{
		xtype: 'hidden',
		itemId: 'applicationProgramId',
		name: 'applicationProgramId'
	}, {
		xtype: 'hidden',
		itemId: 'isOfferType',
		name: 'isOfferType'
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top'
		},
		items: [{
			xtype: 'textfield',
			fieldLabel: getCommonTranslation('ASSIGNED_TO'),
			name: 'txtAdmAssignedTo',
			valueField: 'id',
			width:226,
			displayField: 'value',
			itemId: 'txtAdmassignedToItemId',
			editable: false,
			readOnly: true
		},{
			xtype : 'radiogroup',
			itemId:'rbnAdmFinalApprovalRequireItemId',
			name:'rbnAdmfinalApprovalRequire',
			labelAlign : 'top',
			width:600,
			height:60,
			fieldLabel:getAdmissionTranslation('FINAL_APPROVAL_REQUIRED_BY'),
			items : [{
				boxLabel : getAdmissionTranslation('REGISTRAR_EQUIVALENT'),
				name:'isRegistrarEqu',
				inputValue : 'true',
				checked : true
			},{
				boxLabel : getAdmissionTranslation('REVIEWED_BRAND_CAMPUS'),
				name:'isRegistrarEqu',	
				inputValue : 'false'
			}]
		}]
	},{
    	xtype:'fieldcontainer',
		itemId:'applicableAdmissionReviewPanelId',
		items:[{
            xtype: 'fieldcontainer',
        	layout: 'hbox',
        	width: '100%',
        	itemId:'applicableAdmissionReviewPanel',
        	defaults: {
        		labelAlign: 'top'
        	},
        	items: [{
        	    xtype: 'customcombobox',
      			name: 'dliAdmApplicableAdmissionCondition',
      			itemId: 'dliAdmApplicableAdmissionConditionItemId',
      			allowBlank: false,
      			fieldLabel: getAdmissionTranslation('APPLICABLE_ADMISSION_CONDITION'),
      			store: Ext.create('Academia.store.admission.applicationFormSale.AdmissionConditionByOfferTypeStore'),
      			displayField: 'value',
                valueField: 'id',
      			forceSelection:true,
      			queryParam:'qry',
				editable:false,
				width: 228,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					}
				}
         	 }, {
        		xtype: 'textarea',
     			name: 'txtAdmAdditionlConditions',
     			itemId: 'txtAdmdditionlConditionsItemId',
     			fieldLabel: getAdmissionTranslation('ADDITIONAL_CONDITIONS'),
     			editable:false,
     			readOnly: true,
     			maxLength:2000,
     			width: 226,
     			listeners: {
                    change:function(obj,value){
                    	obj.getEl().dom.setAttribute('data-qtip',value);
                    	obj.getEl().dom.style.textAlign = 'left';
                    	obj.getEl().dom.style.overflow = 'hidden'; 
                    	return '<tpl if="xindex%2==0"><div class="oddColorCombo" style="width:404px"></tpl><tpl if="xindex%2==1"><div class="evenColorCombo" style="width:404px"></tpl> {' + value + '} </div>';
                   }
                }
        	 }, {
        		 xtype: 'datefield',
                 fieldLabel: getAdmissionTranslation('DATE_FOR_SATISFACTION_OF_CONDITION'),
                 name: 'admDateOfSatisfactionCondition',
				 itemId: 'admDateOfSatisfactionConditionItemId',
                 vtype: 'daterange',
                 width: 226,
                 listeners: {
                 	render: function(field) {
                 		return dateFormatRender(field);
                 	}
                 },
                 minValue: new Date()
        	 },{
				xtype: 'button',
				itemId: 'addConditionBtn',
				cls: 'CustomBodyBtnSettings',
				text: getCommonTranslation('ADDBUTTONTEXT'),
				tooltip: getCommonTranslation('ADD'),
				width:30,
				style:{
					marginTop:'30px'
				}
        	}]
       }]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
		    xtype: 'multiselectcombofield',
		    name: 'dliAdmdocumentApplicable',
		    itemId: 'dliAdmdocumentApplicableItemId',
		    store: Ext.create('Academia.store.common.DocumentTypeStore'),
		    displayField: 'value',
		    valueField: 'id',
		    fieldLabel: getAdmissionTranslation('DOCUMENT_APPLICABLE'),
		    cls: 'commonAutoHeightMultiselectField',
		    forceSelection: true,
		    listConfig: {
		        listeners: {
		            beforeshow: function(picker) {
		                picker.minWidth = picker.up('multiselectcombofield').getSize().width;
		                picker.width = picker.up('multiselectcombofield').getSize().width;
		            }
		        }
		    },
		    listeners: {
		        afterrender: function(combo) {
		            Ext.apply(combo, {
		                setReadOnly: function(readOnly) {
		                    this.readOnly = readOnly;

		                    if (readOnly) {
		                        this.inputEl.dom.readOnly = true;

		                        if (this.triggerEl) {
		                            this.triggerEl.each(function(trigger) {
		                                trigger.setDisplayed(false);
		                            });
		                        }

		                        this.onTriggerClick = Ext.emptyFn;
		                    } else {
		                        this.inputEl.dom.readOnly = false;

		                        if (this.triggerEl) {
		                            this.triggerEl.each(function(trigger) {
		                                trigger.setDisplayed(true);
		                            });
		                        }
		                        this.onTriggerClick = Ext.form.field.ComboBox.prototype.onTriggerClick;
		                    }
		                }
		            });
		        }
		    }
		}]

	}, {
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype : 'radiogroup',
			name:'rbnAdmEscalationRequired',
			itemId:'rbnAdmEscalationRequiredItemId',
			labelAlign : 'top',
			height:60,
			labelSeparator : '',
			fieldLabel:getAdmissionTranslation('FURTHER_ESCALATION_REQUIRED'),
			items : [{
				boxLabel : getCommonTranslation('YES'),
				name:'isEscalationRequired',
				inputValue : 'true',
				checked : true
			},{
				boxLabel : getCommonTranslation('NO'),
				name:'isEscalationRequired',	
				inputValue : 'false'
			}]           
		}, {
			xtype: 'customcombobox',
			name:'dliAdmAssignTo',
			store: Ext.create('Academia.store.common.AssignReviewersToApplicationsStore'),
			itemId:'dliAdmAssignToItemId',
			fieldLabel: getCommonTranslation('ASSIGN_TO'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'qry',
			minChars:3,
			allowBlank: false,
			typeAhead:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'+
					'</div>';
				}
			}
		}]
	}]
});