/**
 * @author <a href="mailto:gajendra.verma@serosoft.in">Gajendra Verma</a>
 * 
 */
Ext.define('Academia.view.admission.applications.applicationBase.ApplicantCompetitivePastHistoryLoaderUploadForm', {
	extend: 'Ext.form.Panel',
	alias: 'widget.applicantcompetitivepasthistoryloaderuploadform',
	autoScroll: false,
	frame: false,
	standardSubmit: false,
	defaults: {
		width: 226,
		labelAlign: 'top'
	},
	items : [{
		xtype:'uploadoptionradiogroup',
		width: 330,
		margin: 0,
		itemId:'applicantPastHistoryUploadOptionRadioGroupItemId',
	},{
		xtype:'fieldcontainer',
		width:'auto',
		layout : 'hbox',
		items: [{
			xtype: 'customcombobox',
			name:'uploadType',
			itemId:'uploadTypeItemId',
			labelAlign: 'top',
			store:'importutility.ImportApplicantPastHistoryTypeStore',
			fieldLabel : getProgramandcourseTranslation('TEMPLATE_FOR'),	
			valueField: 'name',
			displayField: 'value',
			typeAhead:false,
			allowBlank:false,
			forceSelection: true,
			editable: false,
			maxLength: 40,
			width: 230
		},{
			xtype: 'customcombobox',
			name: 'importUtilityMasterId',
			width:'auto',
			itemId:'moduleName',
			labelAlign: 'top',
			store:'importutility.ModuleName',
			fieldLabel: getCommonTranslation('TEMPLATE_NAME'),
			valueField: 'id',
			displayField: 'value',
			readOnly:true,
			typeAhead:true,
			forceSelection:true,
			width: 230,
			allowBlank:false
		}]
	},{ 	
		xtype:'fieldcontainer',
		items: [{
			xtype : 'filefield',
			ui : 'CustomBtnThird',
			width: 470,
			fieldLabel : getCommonTranslation('UPLOAD_FILE'),
			buttonText : getCommonTranslation('BROWSE_FILE'),
			itemId : 'uploadFileField',
			labelAlign: 'top',
			name : 'file',
			allowBlank:false,
			validateOnChange : true,
			listeners:{
				change: function(fileField, value) {
					value = value.replace('C:\\fakepath\\', '');
					var newValue = value.replace(/ +/g, " ").split(' ').join('_');
					fileField.setRawValue(newValue);
					if (!isNullOrEmpty(newValue)) {
						var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
						var baseController = Academia.getApplication().getController('Academia.controller.base.BaseController');
						if (!baseController.isValidFileExtensionForLoader(extension)) {
							fileField.reset();
							showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BDU_PLEASE_UPLOAD_CSV_FILE'));
						}
					}
				}
			}
		}]},{ 	
			xtype:'fieldcontainer',
			width:'auto',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getTranslation('UPLOAD_DATA'),
				formBind: true,
				itemId: 'programBatchUpload',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				ui: 'CustomBtnCancel',
				itemId: 'resetBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
});
