Ext.define('Academia.view.admission.applications.applicationBase.ApplicationAndAdmissionComments', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.applicationandadmissioncomments',
	title: getCommonTranslation('APPLICATION_AND_ADMISSION_COMMENTS'),
	border: true,
	autoScroll: false,
	columns : [ {
		header : getCommonTranslation('DATE'),
		dataIndex : 'reassignDate',
		sortable : true,
		flex : 1,
		renderer : function(value){
			return dateRender(value);
		}
	},{
		header: getCommonTranslation('ASSIGNEDBY'), 
		dataIndex: 'assignByUserName',        
		flex: 1,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return value;	
			}else{
				return '-';
			}
		}
	},{
		header: getCommonTranslation('OWNER'), 
		dataIndex: 'reassignUserPrintName',        
		flex: 1,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return value;	
			}else{
				return '-';
			}
		}
	},{
		header : getCommonTranslation('COMMENTS'),
		dataIndex : 'commentText',
		sortable : false,
		flex : 1,
		renderer:function(value, metaData, record, rowIdx, colIdx, store){
			if(!isNullOrEmpty(value)){
				if(value.length > 255) {
					var splitValue = value.slice(0,255);
					metaData.tdAttr = 'data-qtip="' + Ext.String.htmlEncode(value) + '"';
					return splitValue;
				}
				else {
					return value;
				}
			}	
		}
	}],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.callParent(arguments);
    },
    buildStore: function() {
    		return Ext.create('Academia.store.admission.applicationFormSale.ApplicationAndAdmissionCommentsStore');
    }
});