/**
 * @author Amit G
 * 
 */
Ext.define('Academia.view.admission.applications.applicationBase.ConditionsReviewerDetailsAdmGrid', {
	extend: 'Ext.grid.Panel',
	alias : 'widget.conditionsreviewerdetailsadmgrid',
	border: true,
	autoScroll: false,
	header:false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	initComponent: function() {
    	var this$ = this;
    	var store = this$.buildStore();
    	Ext.apply(this$, {
    		store: store
    	});
    	this$.callParent(arguments);
    },
    enableColumnHide: false,
	columns : [{
		header : getCommonTranslation('DATE'),
		dataIndex : 'escalatedByDate',
		sortable : true,
		flex : 1,
		renderer : function(value){
        	return dateRender(value);
        }
	},{
		header : getCommonTranslation('ESCALATED_BY'),
		dataIndex : 'escalatedByUser',
		sortable : false,
		flex : 1
	},{
		header : getCommonTranslation('REVIEWER'),
		dataIndex : 'reviewer',
		sortable : false,
		flex : 1
	},{
		header : getCommonTranslation('OFFER_TYPE'),
		dataIndex : 'admissionOfferType',
		sortable : false,
		flex : 1
	},{
		header : getAdmissionTranslation('APPLICABLE_ADMISSION_CONDITION'),
		dataIndex : 'conditions',
		sortable : false,
		flex :1,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return value;	
			}else{
				return '-';
			}
			
		}
	},{
		header : getAdmissionTranslation('DOCUMENT_APPLICABLE'),
		dataIndex : 'documents',
		sortable : false,
		flex : 1,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return value;	
			}else{
				return '-';
			}
		}
	},{
		header : getCommonTranslation('COMMENTS'),
		dataIndex : 'comments',
		sortable : false,
		flex : 1,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return value;
			}else{
				return '-';
			}
		}
	}],
	buildStore: function() {
        return Ext.create('Academia.store.admission.applicationFormSale.StoApplicationProgramAdmissionDetailHistoryStore');
    }
});