/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show Pre-Admission Payments in grid.
 *   
 */
Ext.define('Academia.view.admission.applications.preAdmissionPaymentsRefundsAndFeePlans.PreAdmissionPaymentsGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.preadmissionpaymentsgrid',    
    title: getAdmissionTranslation('PRE_ADMISSION_PAYMENTS'), //Pre-Admission Payments	    
    border: true,
    plugins:[{
    	 ptype: 'rowexpander',
	     pluginId:'preAdmissionPaymentRowExpander',
	     rowBodyTpl:new Ext.XTemplate('<table style="border:1px solid black; width: 100%;">', 
	        		'<tr>',
     			'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('FEE_HEAD') + '</th>',
     			'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('FEE_AMOUNT') + '</th>',
     			'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('FNP_ADJUSTED_AMOUNT') + '</th>',
     			'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('FNP_PAYMENT_VOUCHER_NUMBER') + '</th>',
     			'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('FNP_PAYMENT_DATE') + '</th>',
     			'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('FNP_VOUCHER_MODE') + '</th>',
     			'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('FNP_ADJUSTED_BILL_NUMBER') + '</th>',
     		'</tr>',
     		'<tpl for="wsApplicationFeeHeadDetails">',
     		'<tr>',
     			'<td style="width:100px;text-align:center">{feeHeadName}</td>',
     			'<td style="width:100px;text-align:center">{amount:this.formatAmountVal}</td>', 
     			'<td style="width:100px;text-align:center">{adjustedAmount:this.formatAmountVal}</td>', 
     			'<td style="width:100px;text-align:center">{receiptNo}</td>', 
     			'<td style="width:100px;text-align:center">{receiptDate:this.dateFormatChange}</td>', 
     			'<td style="width:100px;text-align:center">{voucherMode}</td>',
     			'<td style="width:100px;text-align:center">{adjustedBillNo}</td>',
     		'</tr>', 
     		'</tpl>', 
	        '</table>',{
	        dateFormatChange: function(inputValue) {
	            return dateRender(inputValue);
	        },formatAmountVal : function(val){
    			if(!isNullOrEmpty(val)){
    				return Ext.util.Format.number(val, '0.00');
    			}
    		}
    		})
    }],
    selType : 'checkboxmodel',
    selModel : {
		mode : 'MULTI',
		showHeaderCheckbox : true,
		allowDeselect : true,
		checkOnly : true,
		renderer : function(value, metaData, record, rowIndex,
				colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix
					+ 'grid-cell-special ' + baseCSSPrefix
					+ 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix
					+ 'grid-row-checker">&#160;</div>';
		}
	},
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },        
    initComponent: function() { 
    	var grid=this;
     	var store=Ext.create('Academia.store.admission.applications.preAdmissionPaymentsRefundsAndFeePlans.PreAdmissionPaymentGridStore');
     	Ext.apply(this, {
             store: store        
         });
         this.callParent(arguments);
         var custompagingtoolbar=grid.down('custompagingtoolbar');
         if(custompagingtoolbar){
         	custompagingtoolbar.bindStore(store);        	
         }    	        
    },
    tbar: ['->',{
		xtype: 'button',
		itemId: 'btnPrint',
		disabled : true,
		icon: 'resources/images/print1.png',
		tooltip: getFeeAndPaymentCommonTranslation('Print')
	}],
    columns: [/*{
    	header: getAdmissionTranslation('ACADEMY'), //Academy
    	dataIndex: 'feePlanId',
    	hidden:true    	
    }, {
    	header: getAdmissionTranslation('ACADEMY'), //Academy
    	dataIndex: 'receiptHeaderId',    	
    	hidden:true    	
    },*/{
        header: getAdmissionTranslation('ACADEMY'), //Academy
        dataIndex: 'academyName',
        flex: 1
    }, {
        header: getAdmissionTranslation('LOCATION'), //Location
        dataIndex: 'locationName',
        flex: 1
    }, {
        header: getAdmissionTranslation('PROGRAM'), //Program
        dataIndex: 'programName',
        flex: 1     
    }, {
        header: getAdmissionTranslation('BATCH'), //Batch
        dataIndex: 'batchName',
        flex: 1
    }, {
        header: getAdmissionTranslation('SEAT_TYPE'), //Seat Type
        dataIndex: 'seatType',
        flex: 1
    }, {
        header: getAdmissionTranslation('FEE_PLAN'), //Fee Plan
        dataIndex: 'feePlanName',
        flex: 1        
    },{
		header: getAdmissionTranslation('FEE_PAID'), //Fee Paid        
		dataIndex: 'feePaid',    
		renderer: Ext.util.Format.numberRenderer('0.00'),
		flex: 1           
	}],    
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            displayInfo: true,
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE')
        }]
    }]    
});
