/**
 * @author Amit G
 */
Ext.define('Academia.view.admission.deletedApplicantsReport.DeletedApplicantsReportFilter',{
	extend:'Ext.form.FormPanel',
	alias:'widget.deletedapplicantsreportfilter',
	autoScroll:false,
	
	frame:false,
	standardSubmit:false,
	cls:'panelNoSpace',
	plugins:"formlabelrequired",
	items:[{
		xtype:'panel',
		cls:'customSearchPanel',
		items:[{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:226*2
			},
			items:[{
				xtype: 'customcombobox',
				name:'deletedApplicantId',
				itemId:'deletedApplicantId',
				store:'admission.applications.applicantProfileBase.DeleteApplicationsCodeNameStore',
				fieldLabel:getAdmissionTranslation('ARCHIVED_APPLICANT_NAME'),
				//Archived Application ID/Applicant Name
				width:226*2,
				valueField: 'id',
				displayField: 'value',
				queryParam:'codeOrName',
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
				triggerAction: '',
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	            forceSelection:true,
				  listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{code}/{printName}'  +
		                    '</div>';
		                }
		            }
			}]
		},
		{
			xtype : 'fieldcontainer',
			width : 'auto',
			cls : 'windowBtnPos',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchFilterBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'resetBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]	
		}]
	}]
});
