/**
 * @author Rajkumar.patidar
 *Final admission list search view
 */
Ext.define('Academia.view.admission.manageForm.ManageFormQuickSeachForm', {
	extend: 'Ext.form.Panel',
	alias: 'widget.manageformquickseachform',
	frame: false,
	cls:'customSearchPanel', 
	defaults: {
		labelAlign: 'top'
	},
	layout: 'vbox',
	standardSubmit: false,
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name:'applicationId',
			itemId:'applicationID',
			store:'feeandpayment.managebill.Applicant',
			fieldLabel:getAdmissionTranslation('APPLICATION_NO'),
			valueField: 'id',
			displayField: 'code',
			queryParam:'codeOrName',
			minChars:3,
			typeAhead:false,
			hideTrigger:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name:'applicantName',
			itemId:'applicantName',
			store:'feeandpayment.managebill.Applicant',
			fieldLabel:getAdmissionTranslation('APPLICANT_NAME'),
			valueField: 'applicantPrintName',
			displayField: 'printName',
			queryParam:'codeOrName',
			minChars:3,
			typeAhead:false,
			hideTrigger:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}/{printName}'  +
					'</div>';
				}
			}
		},{
			xtype: 'textfield',
			name: 'FormNo',
			itemId: 'FormNo',
			fieldLabel: getAdmissionTranslation('FORM_NO')
		}]
	},
	{
		xtype : 'fieldcontainer',
		width : 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
			name:'applicationType',
			itemId:'applicationTypeId',
			store:'Academia.store.common.ApplicationTypeStore',
			fieldLabel : getCommonTranslation('APPLICATION_TYPE'),	
			valueField: 'name',
			displayField: 'value',
			typeAhead:false,
			allowBlank:true,
			value:'AllApplications',
			forceSelection: true,
			editable: false,
			maxLength: 40,
		}]
	},{
		xtype:'fieldset',
		title:getFeeAndPaymentCommonTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		width:'100%',
		defaults: {
			labelAlign: 'top',
			width:226
		},
		style: {
         	 marginTop: '10px!important'
        },
		items:[{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				fieldLabel: getAdmissionTranslation('ACADEMY_LOCATION'),
//				translationKey : 'ACADEMY_LOCATION',
				name: 'academyLocation',
				itemId:'academyLocationCombo',
				queryMode : 'local',
				store: 'user.UserAcademyLocationStore',
				displayField: 'value',
				valueField: 'id',
				width:460,
				typeAhead: true,
				forceSelection: true,
				triggerAction: 'all',
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR')
			},{
				xtype: 'customcombobox',
				fieldLabel: getAdmissionTranslation('PROGRAM_GROUP'),
//				translationKey: 'PROGRAM_GROUP',
				name: 'programGroup',
				itemId:'programGroupCombo',
				queryMode : 'local',
				editable: false,
				store: 'program.ProgramGroupStore',
				displayField: 'value',
				valueField: 'id'
			}]
		}, {
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
//				translationKey: 'PROGRAM',
				name: 'program',
				store:'feeandpayment.reports.Program',
				itemId: 'programId',
				valueField: 'id',     
				width:250,
				displayField: 'valueCode',  
				autoload: false,
				typeAhead: true,
				forceSelection: true,
				triggerAction: 'all',
				queryParam:'programName',
	            minChars:3,
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		 			listConfig: {
		 				listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		 				loadingText: getCommonTranslation('SEARCHING'),
		 				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		 				getInnerTpl: function() {
		 					return '<div class="search-item">' +
		 				   '{code} / {value}'+
		 					'</div>';
		 				}
		 			}
				
				
			},{
				xtype: 'customcombobox',
				fieldLabel: getAdmissionTranslation('BATCH'),
				editable: false,
				disabled: true,
				store:'common.BatchesByProgramId',
				name: 'batch',
				itemId: 'batchId',
				valueField: 'id',                
				displayField: 'value'
			},{
				xtype: 'customcombobox',
				fieldLabel: getAdmissionTranslation('SEAT_TYPE'),
				editable: false,
				disabled: true,
				store:'common.SeatTypesByBatchId',
				name: 'seatType',
				itemId: 'seatTypeId',
				valueField: 'seatTypeId',                
				displayField: 'seatTypeName'
			}]	
		}, {
				xtype: 'fieldcontainer',
				width: 'auto',
				layout: 'hbox',
				defaults: {
				labelAlign: 'top',
				width: 226
			},	
			items:[{	 
				xtype: 'label',
				text: getAdmissionTranslation('APPLICATION_DATE'),
		        margin: '10 0 0 0'
		        	
			}]
		    },{
		    	xtype: 'fieldcontainer',
				width: 'auto',
				layout: 'hbox',
				defaults: {
					labelAlign: 'top',
					width: 226
				},
			items: [{
				xtype: 'datefield',
				name: 'fromDate',
				itemId:'fromDate',
//				format: CONSTANTS.DATE_FORMAT,
				//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
				editable:true,
				vtype: 'daterange',
				endDateField: 'toDate',
				fieldLabel: getAdmissionTranslation('FROM_DATE'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			},{
				xtype: 'datefield',
				name: 'toDate',
				itemId:'toDate',
//				format: CONSTANTS.DATE_FORMAT,
				//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
				vtype: 'daterange',
				startDateField: 'fromDate',
				editable:true,
				fieldLabel: getAdmissionTranslation('TO_DATE'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			}]
		}, {
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width:'auto',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'numberfield',
				name: 'enqContactNo',
				itemId: 'enqContactNo',
				hidden:true,
				hideTrigger: true,
				mouseWheelEnabled:false,
				minValue:0,
				fieldLabel : getAdmissionTranslation('CONTACT_NO')//Contact No.
			}, {
				xtype: 'textfield',
				name: 'email',
				vtype:'email',
				itemId: 'enqEmailId',
				fieldLabel : getAdmissionTranslation('EMAIL_ID')//Email ID,
			},{
				xtype: 'textfield',
				name: 'receiptNo',
				hidden:true,
				itemId: 'receiptNo',
				fieldLabel : getAdmissionTranslation('RECEIPT_NO')//Contact No.
			}]
		}],
		listeners:{
			render: function(myfieldset){
				myfieldset.setMargin('-10px');
			}
		}
		},{
			xtype : 'fieldcontainer',
			width : 'auto',
			items : [{
				xtype : 'button',
				text : getCommonTranslation('SEARCH'),
				itemId : 'manageFormSearchBtn',
				buttonAlign : 'left',
				ui : 'CustomBtnSubmit',
				formBind:true,
				scale: CONSTANTS.BUTTONSIZE
			}, {
				xtype: 'button',
				text : getCommonTranslation('RESET'),
				itemId : 'manageFormResetBtn',
				buttonAlign : 'left',
				ui : 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
	}]
});
