/**
 * @author Pravin.Surve
 */
Ext.define('Academia.view.admission.replacement.ViewReplacementListGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.viewreplacementlistgrid',
    title: getAdmissionTranslation('REPLACEMENT_LIST'),
    border: true,
    autoScroll: false,
    columnLines : true,
    selModel:Ext.create('Ext.selection.CheckboxModel',{
		checkOnly: true,
	    mode: 'multi',
    	showHeaderCheckbox : false
    }),
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    tbar: [{
    	xtype:'label',
    	text: getAdmissionTranslation('REPLACED_STUDENT'),
    	style : {
    		marginLeft : '155px'
    	}
    },{
    	xtype:'label',
    	text: getAdmissionTranslation('REPLACED_BY'),
    	style : {
    		marginLeft : '270px'
    	}
    }],
    columns: [{
        header: getAdmissionTranslation('REPLACE_TO_APPLICATION_ID'),
        dataIndex: 'replacedToBeAppId',
        sortable: true,
        flex: 0.6
        /*renderer: function(value) {
            return '<a href="#">' + value + '</a>';
        }*/
    }, {
        header: getAdmissionTranslation('STUDENT_NAME'),
        dataIndex: 'replacedToBeAppName',
        sortable: true,
        flex: 0.6
    }, {
        header: getAdmissionTranslation('CURRENT_STATUS'),
        dataIndex: 'replacedToBeStageStatus',
        sortable: true,
        flex: 0.6
    },{
        header: getAdmissionTranslation('REPLACE_BY_APPLICATION_ID'),
        dataIndex: 'replacedByAppId',
        sortable: true,
        flex: 0.6
        /*renderer: function(value) {
            return '<a href="#">' + value + '</a>';
        }*/
    }, {
        header: getAdmissionTranslation('STUDENT_NAME'),
        dataIndex: 'replacedByAppName',
        sortable: true,
        flex: 0.6
    }, {
        header: getAdmissionTranslation('CURRENT_STATUS'),
        dataIndex: 'replacedByStageStatus',
        sortable: true,
        flex: 0.6
    }],

    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        this$.selModel=Ext.create('Ext.selection.CheckboxModel',{    		    	
			checkOnly: true,
		    mode: 'multi'
        });
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
                    displayInfo: true
                }]
            }]
        });

        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.admission.replacement.ViewReplacementListStore');
    }

});