Ext.define('Academia.view.admission.selectionProcess.SelectionProcessStageWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.spstagewindow',
    modal: true,
    resizable: false,
    autoScroll: true,
    width:625,
    frame: true,
    title: getAdmissionTranslation('SELECTION_PROCESS_STAGES'), 
    bodyStyle:{
      padding: '31px 22px 18px 22px !important'
    },
    items: [{
        xtype: 'form',
        itemId: 'spStageForm',
        standardSubmit: false,
        plugins: "formlabelrequired",
		layout: {
			type: 'vbox',
		},
		defaults :{
			width: '100%',
			labelAlign:'top'
		},
        items: [{
			xtype:'fieldcontainer',
			layout:'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
	        	xtype : 'hidden',
	        	name: 'id'
	        },{
	        	xtype : 'hidden',
	        	name: 'version'
	        },{
	            xtype: 'customcombobox',
	            name: 'stageId',
	            itemId : 'stageCombo',
	            labelAlign: 'top',
	            fieldLabel: getAdmissionTranslation('STAGE'), 
	            allowBlank: false,
//	            flex: 1,
	            displayField: 'value',
	            valueField: 'id',
	            width: 274,
	            store: 'Academia.store.course.CourseStageStore'
	        }, {
				xtype : 'numberfield',
				name : 'expNumberOfDays',
				labelAlign: 'top',
				labelWidth : 'auto',
				width: 274,
				fieldLabel : getAdmissionTranslation('NUMBEROFDAYSREQUIRED'),
				allowBlank: false,
				minValue: 0,
				maxValue: 365
			}]
        },{
			xtype:'fieldcontainer',
			layout:'hbox',
			defaults: {
				width: '100%',
				labelAlign: 'top'
			},
			items:[{
	        	xtype: 'checkbox',
	        	labelAlign: 'left',
	        	name: 'committeeApprovalRequired',
	        	inputValue: true,
//	            labelWidth: 280,
	            style: {
		               marginTop: '2px'
		        	},
	        	boxLabel: getAdmissionTranslation('APPROVALREQUIRED')
	        }]
        }, {
			xtype:'fieldcontainer',
			layout:'hbox',
			defaults: {
				width:'100%',
				labelAlign: 'top'
			},
			items:[{
	        	xtype: 'textarea',
	        	name: 'remark',
	        	labelAlign: 'top',
//	            width: 226,
	        	style: {
	               marginTop: '13px'
	        	},
	        	fieldLabel: getAdmissionTranslation('GENERALREMARKS')
	        }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            items: [{
                xtype: 'button',
                itemId: 'btnSaveStageDetails',
                text: getCommonTranslation('SUBMIT'), //Submit
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true    
            }, {
                xtype: 'button',
                itemId: 'btnCancelStageDetails',
                text: getCommonTranslation('CANCEL'), //Cancel
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]

});