/**
 * This Grid is used for Stage Statistics Grid of the Selection Stage.
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.admission.selectionStage.TransferSeatsGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport', 
	
	alias : 'widget.transferseatsgrid',
	title : getAdmissionTranslation('TRANSFER_SEATS'),
	border : true,
	columns : [/*{
		hidden: true,
		dataIndex: 'quotaTypeId'
	},*/{
		text: getAdmissionTranslation('SEAT_TYPE'),
		dataIndex: 'seatTypeName',
		flex: 1,
		sortable : false
	},{
		text: getAdmissionTranslation('QUOTA_TYPE'),
		dataIndex: 'quotaTypeName',
		flex: 1,
		sortable : false
	},{
		text : getAdmissionTranslation('QUOTA'),
		dataIndex: 'quota',
		flex: 1,
		sortable : false
	},  {
		text : getAdmissionTranslation('MIN_SEAT'),
		dataIndex: 'overriddenMinSeat',
		flex: 1,
		sortable : true,
		renderer: function(value, metaData , record ) {
			if(isNullOrEmpty(value))
				value=record.get('minSeat');
			return value;
			}
	}, {
		text : getAdmissionTranslation('MAX_SEAT'),
		dataIndex : 'overriddenMaxSeat',
		flex: 1,
		sortable : true,
		renderer: function(value, metaData , record ) {
			if(isNullOrEmpty(value))
				value=record.get('maxSeat');
			return value;
		}
	},  {
		text : getAdmissionTranslation('TOTAL_STUDENTS'),
		dataIndex: 'numberOfApplication',
		flex: 1,
		sortable : true
	}, {
		text : getCommonTranslation('SELECTED'),
		dataIndex : 'numberOfSelectedStudents',
		flex: 1,
		sortable : true
	}, {
		text : getAdmissionTranslation('QUOTA_VIOLATION'),
		dataIndex : 'violation',
		flex: 1,
		sortable : true
	}],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE') ,
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.admission.selectionStage.TransferSeats');
    },
    tbar : [{
		//xtype: 'fieldcontainer',
		//items: [{
			xtype: 'multiselectcombofield',
			autoloadStore:false,
			itemId: 'seatTypesCombo',
			labelWidth :85,
        	fieldLabel: getAdmissionTranslation('SEAT_TYPES'), 
        	store: 'Academia.store.admission.selectionStage.SeatTypePickList',
        	//emptyText:'Select',
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
    		typeAhead: false,
    		width: 400,
//            allowBlank: false
		//}]
	}, {
		xtype: 'button',
		itemId: 'addColumn',
		tooltip : getAdmissionTranslation('TRANSFER_SEATS'),
		text: getAdmissionTranslation('TRANSFER_SEATS')
	}, {
		xtype: 'button',
		itemId: 'previewChange',
		tooltip : getAdmissionTranslation('PREVIEW_CHANGE'),
		text: getAdmissionTranslation('PREVIEW_CHANGE')
	}, {
		xtype: 'button',
		itemId: 'applySeatTransfers',
		tooltip : getAdmissionTranslation('APPLY_SEAT_TRANSFERS'),
		text: getAdmissionTranslation('APPLY_SEAT_TRANSFERS')
	}]
});