/**
 * @author Prakash Sharma
 */
Ext.define('Academia.view.applicantportalsetup.ApplicantPortalSetupGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.applicantportalsetupgrid',
	store: 'Academia.store.applicantPortalSetup.ApplicantPortalSetupGridStore',
	title: getCommonTranslation('APPLICANT_SETUP_GRID_LABEL'),
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	frame:false,
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'applicantportalsetupform':1
		}
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		itemId : 'dockedItemId',
		items : [{
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'Academia.store.applicantPortalSetup.ApplicantPortalSetupGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation("EDIT"),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},/*{
		xtype: 'button',
		itemId: 'btnApply',
		tooltip: getCommonTranslation('APPLY'),
		text: getCommonTranslation('APPLY'),
		
	},{
		xtype: 'button',
		itemId: 'btnCopy',
		tooltip: getCommonTranslation('COPY'),
		text: getCommonTranslation('COPY'), 
		
	},*/{
			xtype : 'splitbutton',
	        itemId:'spBtnMoreActions',
	        text : getCommonTranslation('MOREACTIONS'),
	        menu:[{
	            text:getCommonTranslation('APPLY'),
	            itemId:'btnApply'
	        },{
	            text:getCommonTranslation('RENAME'),
	            itemId:'btnRename'
	        },{
	            text:getCommonTranslation('COPY'),
	            itemId:'btnCopy'
	        }],
	        listeners: { click: function() { this.showMenu(); } }
	      },{
	  		xtype: 'button',
	  		itemId: 'viewDefaultProgramSetup',
	  		tooltip : getCommonTranslation('DEFAULT_PROGRAM_DETAILS_SETUP'),
	  		text:  getCommonTranslation('DEFAULT_PROGRAM_DETAILS_SETUP')
	  	
	      }],
	columns: [{
		header:  getCommonTranslation('APPLICANT_PORTAL_SETUP_NAME'),
		dataIndex: 'setupName',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('CREATED_BY'),
		dataIndex: 'printName',
		flex:1,
		sortable:true
		
	},{
		header:  getCommonTranslation('CREATION_DATE'),
		dataIndex: 'createdDate',
		flex:1,
		sortable:true,
		renderer:function(value) {
			return dateRender(value);
		}
	},{
		header:  getExaminationTranslation('MAPPED_STATUS'),
		dataIndex: 'mappingStatus',
		flex:1,
		sortable:true,
		renderer:function(value) {
			return value == true ? 'Mapped' : 'Unmapped';
		}
	},{
		header:  getCommonTranslation('STATUS'),
		dataIndex: 'status',
		flex:1,
		sortable:true,
		renderer:function(value) {
			return value == true ? 'Active' : 'Inactive';
		}
	}]
});
