/**
 * @author Dharmendra.prajapati
 * 
 */
Ext.define('Academia.view.attendance.StudentAttendance',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.studentattendance',
	plugins : "formlabelrequired",
	frame: false,
	border:false,
	autoScroll:false,
	method : 'POST',
	collapsible:false,
	standardSubmit : false,
	cls:'horizontalScrollingFixed',
	layout : {
		type : 'vbox'
	},
	defaults : {
		labelAlign : 'top',
		width : 226
	},
	items : [{
		xtype:'hidden',
		name:'sessionPlanningDone'
	},{
		xtype:'hidden',
		name:'courseVariantId'
	},{
		xtype:'hidden',
		name:'facultyCourseVarient'
	},{
		xtype:'hidden',
		name:'attendanceType'
	},{
		xtype:'hidden',
		name:'noOfBackDays'
	},{
		xtype:'hidden',
		name:'sessionPlanningFlag'
	},{
		xtype:'hidden',
		itemId:'calendarId',
		name:'calendarId'
	},{
		xtype:'hidden',
		name:'courseSectionType'
	},{
		xtype:'hidden',
		name:'facultyConflictCheck'
	},{
		xtype:'hidden',
		name:'adhocRequired'
	},{
		xtype:'hidden',
		name:'attendanceSlot'
	},{
		xtype:'form',
		frame:false,
		width:'100%',
		items: [{
			xtype : 'fieldcontainer',
			itemId:'programBatch_Id',
			width: 'auto',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype : 'hidden',
				name : 'id'
			},{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				name : 'programId',
				itemId : 'programBatch_programId',
				store:'common.ClassTeacherProgramStore',
				displayField:'valueCode',
				valueField:'id',
				width:460,
				allowBlank:false,
				typeAhead:true,
				forceSelection:true,
				minChars:3,
				queryParam:'name',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},
			{
				xtype: 'customcombobox',
				name: 'batchId',
				itemId:'programBatch_batchId',
				fieldLabel : getCourseTxCommonTranslation('BATCH'),
				allowBlank: false,
				disabled:true,
				store: 'enquiry.AcademicBatchStore',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true
			},{
				xtype: 'customcombobox',
				name: 'service',
				itemId:'serviceId',
				fieldLabel : getProgramandcourseTranslation('SERVICE'),
				allowBlank: false,
				disabled:false,
				store: 'attendance.ServiceStore',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true,
				hidden : true
			},{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				name : 'serviceprogram',
				itemId : 'serviceProgramId',
				store : Ext.create('Academia.store.common.ServiceMappedProgram'),
				//store:'common.ServiceMappedProgram',
				displayField:'valueCode',
				valueField:'id',
				//width:460,
				allowBlank:false,
				typeAhead:true,
				forceSelection:true,
				minChars:3,
				hidden : true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
				xtype: 'multiselectcombofield',
				name: 'serviceBatch',
				itemId:'serviceBatchId',
				fieldLabel: getCourseTxCommonTranslation('PROGRAM_BATCH'),
				allowBlank: false,
				disabled:true,
				store: 'attendance.BatchByServiceStore',
				valueField: 'id',
				displayField: 'programBatchName',
				typeAhead:false,
				editable: false,
				forceSelection:true,
				hidden : true,
				autoSelect: false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				//cls:'ProgramCourseMultiselectField resetPasswordMultiselect',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}
			},
			]},{
				xtype : 'fieldcontainer',
				width: 'auto',
				defaults : {
					width : 226,
					labelAlign : 'top'
				},
				layout : {
					type : 'hbox'
				},
				items : [{
					xtype : 'customcombobox',
					fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
					name : 'ACADEMIC_TERM',
					itemId : 'academicTerm',
					displayField : 'value',
					valueField : 'id',
					typeAhead : true,
					forceSelection : true,
					hidden : true,
					listeners  :{
						render : function(combo){
							var store=Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId');
							combo.bindStore(store)
						}
					}
				},{
					xtype : 'customcombobox',
					width:226,
					fieldLabel : getCommonTranslation('COURSE_CODE_NAME'),
					name : 'courseId',
					itemId : 'courseId',
					store:Ext.create('Academia.store.attendance.facultyportal.AttendanceCourses'),
					displayField : 'courseCodeName',
					valueField : 'courseId',
					typeAhead : true,
					disable:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					hideTrigger:false,
					minChars:3,
					forceSelection : true,
					allowBlank:false,
					hidden:true,
					triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
					queryParam:'name',
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{courseCodeName}'  +
							'</div>';
						}
					}
				}]
			},{
				xtype : 'fieldcontainer',
				width: 'auto',
				defaults : {
					width : 226,
					labelAlign : 'top'
				},
				layout : {
					type : 'hbox'
				},
				items : [{
					xtype : 'customcombobox',
					fieldLabel : getCourseTxCommonTranslation('COURSE_VARIANT'),
					name : 'courseVariant',
					itemId : 'courseVariantId',
					store:Ext.create('Academia.store.attendance.facultyportal.AttendanceCourseVariantStore'),
					displayField : 'courseVariantCode',
					valueField : 'id',
					typeAhead : true,
					forceSelection : true,
					allowBlank:false,
					hidden:true
				},{
					xtype : 'customcombobox',
					width: 226,
					labelAlign: 'top',
					fieldLabel : getProgramandcourseTranslation('FACULTY'),
					itemId:'facutlyListId',
					name : 'facutlyList',
					store:'attendance.AttendanceFacultyList',
					displayField : 'facultyName',
					valueField : 'facultyId',
					allowBlank:false,
					typeAhead : true,
					forceSelection : true,
					hidden:true
				}]
			},{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items :[{
					xtype: 'customcombobox',
					name: 'periodId',
					itemId:'periodIdItemId',
					fieldLabel: getExaminationTranslation('PERIOD'),
					store:Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod'),
					displayField:'value',
					valueField:'id',
					forceSelection:true,
					typeAhead:true,
					disabled:true,
					allowBlank: false
				},{
					xtype : 'customcombobox',
					fieldLabel : getCourseTxCommonTranslation('SECTION'),
					width: 226,
					labelAlign: 'top',
					name : 'sectionId',
					itemId : 'programCoursection_ID',
					store:'attendance.SectionAndFacultyByPeriodID',
					displayField : 'sectionCode',
					valueField : 'sectionId',
					typeAhead : true,
					disabled:true,
					forceSelection : true,
					allowBlank: false
				},{
					xtype : 'customcombobox',
					fieldLabel : getProgramandcourseTranslation('FACULTY'),
					width: 226,
					labelAlign: 'top',
					itemId:'facutlyId',
					name : 'facutly',
					store:'attendance.SectionAndFacultyByPeriodID',
					displayField : 'facultyName',
					valueField : 'facultyId',
					typeAhead : true,
				    readOnly :true,
					forceSelection : true
				}]},{
					xtype : 'fieldcontainer',
					width: 'auto',
					layout: 'hbox',
					defaults : {
						labelAlign : 'top'
					},
					items : [{
						xtype: 'multiselectcombofield',
						addAllSelector: false,
						name: 'timetableSlotList',
						itemId:'timetableSlotListId',
						width: 460,
						labelAlign: 'top',
						fieldLabel: getCourseTxCommonTranslation('TIME_SLOT'),
						store:Ext.create('Academia.store.attendance.facultyportal.DetailedTimeSlotList'),
						displayField:'value',
						valueField:'id',	
						autoloadStore: false,
						disabled:false,
						typeAhead:false,
						forceSelection:true,
						cls:'commonAutoHeightMultiselectField resetPasswordMultiselect',
						allowBlank: false,
						height:'auto',
						listConfig :{         
							listeners :{ 
								beforeshow: function(picker) {
		        					picker.width = picker.up('combobox').getSize().width;
		        				},
								refresh: function( boundList, eOpts ){
										try{
											var combo = boundList.up('combo');
											var newValue = combo.getValue();
											if(!isNullOrEmpty(newValue[0])){
												var allItems = combo.listKeyNav.boundList.all.elements;
												var selectedDate = '';
												if(typeof combo.getDisplayValue() == "string"){
													selectedDate = combo.getDisplayValue().split(" - ")[0];
												}
												else{
													selectedDate = combo.getDisplayValue()[0].split(" - ")[0];
												}
												var comboDisplayVal = 
												Ext.each(allItems, function(currentItem){
													var currentDate = currentItem.innerText.split(" - ")[0];
													if(findInArray(newValue,currentItem.viewRecordId) || selectedDate == currentDate){
														currentItem.classList.remove("disabledComboItem")
													}
													else{
														currentItem.classList.add("disabledComboItem");
													}
												});
											}
										}
										catch(e){}
								}
							}
						},
						listeners:{
							beforeselect:function(selModel,record,index){
								var combo = selModel.view.field;
								if(!isNullOrEmpty(combo.getValue()) && combo.getValue() != "") {
									var value = combo.getValue();
									if(value[0].data.sessionDate != record.data.sessionDate)
										return false;
								}
							},
							change: function(combo, newValue, oldValue, eOpt){
								var allItems = combo.listKeyNav.boundList.all.elements;
								var selectedDate = '';
								if(typeof combo.getDisplayValue() == "string"){
									selectedDate = combo.getDisplayValue().split(" - ")[0];
								}
								else{
									selectedDate = combo.getDisplayValue()[0].split(" - ")[0];
								}
								var comboDisplayVal = 
								Ext.each(allItems, function(currentItem){
									var currentDate = currentItem.innerText.split(" - ")[0];
									if(findInArray(newValue,currentItem.viewRecordId) || selectedDate == currentDate){
										currentItem.classList.remove("disabledComboItem")
									}
									else{
										currentItem.classList.add("disabledComboItem");
									}
								});
							}
						}
					}]
				},{
					xtype : 'fieldcontainer',
					width: 'auto',
					layout: 'hbox',
					defaults : {
						labelAlign : 'top'
					},
					items : [{
						xtype: 'multiselectcombofield',
						itemId: 'topicId',
						name: 'topicId',
						width:460,
						fieldLabel: getCommonTranslation('TOPICS'),
						store:Ext.create('Academia.store.attendance.StudentAttendanceTopic'),
						displayField: 'value',
						valueField: 'id',	
						typeAhead:false,
						editable: false,
						forceSelection:true,
						autoSelect: false,
						disabled:true,
						hidden:true,
						triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
						enableKeyEvents  : 'true',
						hideTrigger:false,
						cls:'ProgramCourseMultiselectField resetPasswordMultiselect',
						listConfig: {
							listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
							loadingText: getCommonTranslation('SEARCHING'),
							emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							getInnerTpl: function() {
								return '<div class="search-item">' +
								'{code}' +
								'</div>';
							}
						}
					}]
				},{
					xtype : 'fieldcontainer',
					width: 'auto',
					layout: 'hbox',
					defaults : {
						width : 226,
						labelAlign : 'top'
					},
					items : [{
						xtype : 'datefield',
						fieldLabel : getProgramandcourseTranslation('DATE'),
						name : 'dateOfAttendance',
						itemId:'dateOfAttendance_Id',
						maxValue : new Date(),
						vtype : 'daterange',
						allowBlank: false,
						listeners: {
							render: function(obj) {
								obj = dateFormatRender(obj);						
								obj.setValue(new Date());
							}
						}
					}, {
						xtype: 'customcombobox',
						width : 226,
						fieldLabel: getProgramandcourseTranslation('SESSION_NO'),
						name:'sessionNo',
						itemId: 'sessionItemId',
						displayField: 'val',
						valueField: 'code',
						allowBlank:false,
						hidden:true,
						forceSelection:true,
						queryMode:'local'
					},{
					xtype: 'multiselectcombofield',
					name: 'timeSlotList',
					itemId:'timeSlotListId',
					labelAlign: 'top',
					fieldLabel: getCourseTxCommonTranslation('TIME_SLOT')+'<span class="required" style="color:red"> *</span>',
					store:'attendance.TimeSlotList',
					displayField:'value',
					valueField:'value',	
					autoloadStore: false,
					disabled:true,
					typeAhead:true,
					forceSelection:true,
					height:'auto'
//						hidden:true
				},{
	        		xtype:'multiselectcombofield',
	        		itemId:'serviceCoordinatorId',
	        		name:'serviceCoordinatorName',
	        		fieldLabel:getCommonTranslation('SERVICE_COORDINATOR'),
	        		displayField:'staffName',
	        		valueField:'coordinatorId',
	        		store:Ext.create('Academia.store.lecturercostingdefinition.LCDServiceCoordinatorStore'),
	    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	    			minChars:3,
	    			queryParam:'name',
	    			height:30,
	    			typeAhead:true,
	    			disabled:true,
	    			hidden:true,
	        		listConfig: {
	        			listeners: {
	        				beforeshow: function(picker) {
	        					var combo = picker.up('combobox');
								picker.setWidth(combo.getWidth());
	        					//picker.minWidth = picker.up('combobox').getSize().width;
	        				}
	        			},
	        			loadingText: getCommonTranslation('SEARCHING'),
	        			emptyText: getCommonTranslation('NO_RECORDS_FOUND')
	        		}
	        	}]
				},{
					xtype:'panel',
					itemId:'panelId',
					layout : 'vbox',
					style:{
						marginLeft:'-10px',
						marginTop:'0px'
					},
					items:[{
						xtype : 'fieldcontainer',
						width: 'auto',
						itemId:'timeContainer',
						name:'timeContainer',
						hidden:true,
						layout : 'hbox',
						defaults : {
							labelAlign : 'top'
						},
						items : [{
							xtype : 'timefield',
							name : 'fromTime',		
							itemId : 'fromTime',			
							fieldLabel:getProgramandcourseTranslation('START_TIME'),
							format:'g:i A',
							increment: 1,
							vtype: 'timerange',
							width:100,
							allowBlank:false,
							listeners:{
								change:function(obj,val){
									if (!isNullOrEmpty(val)) {
										var sDate = Ext.Date.add(val, Ext.Date.MINUTE, 1);
										obj.nextSibling().setMinValue(sDate);	
									}
								}
							}
						},{
							xtype : 'timefield',
							name : 'toTime',		
							itemId : 'toTime',			
							fieldLabel:getProgramandcourseTranslation('END_TIME'),
							format:'g:i A',
							vtype: 'timerange',
							increment: 1,
							width:100,
							allowBlank:false,
							listeners:{
								change:function(obj,val){
									if (!isNullOrEmpty(val)) {
										var eDate = Ext.Date.add(val, Ext.Date.MINUTE, -1);
										obj.previousSibling().setMaxValue(eDate);
									}
								}
							}
						},{
							xtype : 'button',
							itemId: 'timeBtnAdd',
							cls: 'CustomBodyBtnSettings',
							text: getCommonTranslation('ADDBUTTONTEXT'),
							tooltip: getCommonTranslation('ADD'),
							style:{
								marginTop:'30px'
							}
						}
						]}
					]},{
						xtype: 'fieldcontainer',
						width: 'auto',
						layout : 'hbox',
						style:{
							marginTop:'-30px'
						},
						items: [{
							xtype: 'button',
							text: getCommonTranslation('SEARCH'),
							itemId: 'searchBtn',
							buttonAlign: 'left',
							ui: 'CustomBtnSubmit',
							formBind : true,
							disabled:true,
							scale: CONSTANTS.BUTTONSIZE
						},{
							xtype: 'button',
							text: getCommonTranslation('GENERATE_QR'),
							itemId: 'GenrateQR',
							buttonAlign: 'left',
							ui: 'CustomBtnSubmit',
							formBind : true,
							disabled:true,
							scale: CONSTANTS.BUTTONSIZE
						},{
							xtype: 'button',
							text: getCommonTranslation('VIEW_QR'),
							itemId: 'viewQR',
							buttonAlign: 'left',
							ui: 'CustomBtnSubmit',
							formBind : true,
							disabled:true,
							hidden: true,
							scale: CONSTANTS.BUTTONSIZE
						},{
							xtype: 'button',
							text: getCourseTxCommonTranslation('RESET'),
							itemId: 'resetBtn',
							buttonAlign: 'left',
							ui: 'CustomBtnCancel',
							scale: CONSTANTS.BUTTONSIZE
						}]
					}]
	}]
});
