/**
 *  Akshay Sharma
 */
Ext.define('Academia.view.attendance.StudentLeaveReportGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.studentleavereportgrid',
	store : 'attendance.StudentLeaveReportStore',
	title : getProgramandcourseTranslation('LEAVE_REPORT'),
	border: true,
	refreshStoreData:true,
//	id:'myleavereportgridId',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
		      xtype: 'custompagingtoolbar',
	          plugins:['pagesize'],
			store : 'attendance.StudentLeaveReportStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}
	],
	initComponent: function() {

        var grid=this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     

 },
	columns : [{
		header :getCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentCode',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex : 1,
		sortable : true
	},{
		header :getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex : 1,
		sortable : true
	}, {
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex : 1,
		sortable : true
	}, {
		header : getCommonTranslation('PERIOD'),
		dataIndex : 'periodName',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('COURSE'),
		dataIndex : 'courseName',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('SECTION'),
		dataIndex : 'sectionCode',
		flex : 1,
		sortable : true
	},{
		header : getProgramandcourseTranslation('ABSENT_DATE'),
		dataIndex : 'dateOfAbsence',
		sortable : true,
		flex : 1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header : getCommonTranslation('APPLIED_DATE'),
		dataIndex : 'appliedDate',
		flex : 1,
		sortable : true,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header : getCommonTranslation('LEAVE_STATUS'),
		dataIndex : 'leaveStatus',
		flex : 1,
		sortable : true,
	},{
		header : getProgramandcourseTranslation('APPROVED_DATE_AND_TIME'),
		dataIndex : 'actionDate',
		flex : 1,
		sortable : true,
		renderer: function(date) {
			if(!isNullOrEmpty(date))
            return dateRender(date)+" "+datetimeRender(date);
        }
	}]
});
