/**
 * Abhishek Bais
 * 
 */
Ext.define('Academia.view.attendance.courseattendance.CourseSearchAttendanceSectionGroup', {   
	extend : 'Academia.view.common.DynamicFieldForm',
	alias : 'widget.coursesearchattendancesectiongroup',  
	plugins : "formlabelrequired",
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	method: 'POST',
	standardSubmit: false,
	items: [{
		xtype : 'hidden',
		name:'selectedStudentId',
		itemId:'selectedStudentId'
	},{
		xtype : 'hidden',
		name:'selectedPeriodId',
		itemId:'selectedPeriodId'
	},{
		xtype : 'fieldcontainer',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: '226',
			labelAlign : 'top'
		},
		items : [{
			xtype : 'hidden',
			name : 'id'
		},{
			xtype : 'customcombobox',
			name : 'academyLocation',
			itemId:'academyLocationId',
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:'attendance.attendancereport.AcadmyByAdmission',
			width:226,
			valueField : 'id',
			displayField : 'value',
		//	allowBlank : false,
			minChars:3,
			typeAhead : false,
			forceSelection:true,
			hideTrigger:false,
			triggerAction: 'all',
			queryParam:'qry',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('SECTION_GROUP'),
			name : 'sectionGroupId',
			itemId : 'sectionGroupId',
			store : Ext.create('Academia.store.coursetransaction.sectionmanagement.SectionGroupStore'),
			displayField : 'value',
			valueField : 'id',
			typeAhead : true,
			forceSelection : true,
			width: 226,
	//		allowBlank:false,
			editable : false
			
		},{
	        xtype: 'customcombobox',
	        name: 'academicTerm',
	        itemId: 'academicTermId',
	        width:226,
	        fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
	        store: Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
	        valueField: 'id',
	        displayField: 'value',
	        allowBlank: false,
	        forceSelection:true,
	        typeAhead : false,
			editable : false
	    }]
	},{
		xtype : 'fieldcontainer',
		itemId:'programBatch_Id',
		width: 'auto',
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'hidden',
			name : 'id'
		},{
        	xtype: 'customcombobox',
            name: 'programCategory',
            itemId : 'programCategoryId',
            fieldLabel: getProgramandcourseTranslation('PROGRAM_CATEGORY'),
//            translationKey: 'PROGRAM_CATEGORY',
            store: Ext.create('Academia.store.program.ProgramCategoryByAlStore'),
            displayField:'value',
            valueField:'id',
            forceSelection:true,
            //allowBlank: false
        },{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			name : 'programId',
			itemId : 'programBatch_programId',
			store:Ext.create('Academia.store.programCourseDashboard.SectionGroupParameterizedProgramBatchStore'),
			displayField:'valueCode',
			valueField:'id',
			width:226,
			typeAhead:false,
			disabled:true,
			forceSelection:true,
			allowBlank : false,
			queryParam:'programName',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'batchId',
			itemId:'programBatch_batchId',
			fieldLabel : getCourseTxCommonTranslation('BATCH'),
			disabled:true,
			store: Ext.create('Academia.store.programCourseDashboard.SectionGroupParameterizedProgramBatchStore'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:false,
			forceSelection:true,
			allowBlank : false,
			width: 226,
			editable : false
		}]
	},{
		 xtype : 'fieldcontainer',
		 width: 'auto',
		 defaults : {
			 width : 226,
			 labelAlign : 'top'
		 },
		 layout : {
			 type : 'hbox'
		 },
		 items : [{
			 xtype: 'customcombobox',
			 name: 'periodId',
			 itemId:'programBatch_periodId',
			 fieldLabel: getExaminationTranslation('PERIOD'),
			 store: Ext.create('Academia.store.programCourseDashboard.SectionGroupParameterizedProgramBatchStore'),
			 displayField:'value',
			 valueField:'id',
			 forceSelection:true,
			 typeAhead:false,
		//	 allowBlank : false,
			 disabled:true,
			 width: 226,
			 editable : false
		 },{
			 xtype : 'customcombobox',
			 fieldLabel : getCommonTranslation('COURSE_CODE_NAME'),
			 name : 'courseId',
			 itemId : 'courseId',
			 //store:'attendance.StudentCourses',
			 store:Ext.create('Academia.store.programCourseDashboard.SectionGroupParameterizedCourseStore'),
			 displayField : 'valueCode',
			 valueField : 'id',
			 disabled:true,
			 forceSelection : true,
			 queryParam:'name',
			 minChars:3,
			 hideTrigger:false,
			 typeAhead:true,
			 triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			 listConfig: {
				 listeners: {
					 beforeshow: function(picker) {
						 picker.minWidth = picker.up('combobox').getSize().width;
					 }
				 },
				 loadingText: getCommonTranslation('SEARCHING'),
				 emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				 getInnerTpl: function() {
					 return '<div class="search-item">' +
					 '{courseCodeName}'  +
					 '</div>';
				 }
			 }
		 },{
			 xtype : 'customcombobox',
			 fieldLabel : getCourseTxCommonTranslation('COURSE_VARIANT'),
			 name : 'courseVariant',
			 itemId : 'courseVariantId',
			 store:Ext.create('Academia.store.programCourseDashboard.SectionGroupParameterizedCourseStore'),
			 displayField : 'valueCode',
			 valueField : 'id',
			 typeAhead : true,
			 forceSelection : true,
			 disabled:true,
			 editable : false
		 }]
	},{

		xtype: 'fieldset',
		collapsible : true,
		collapsed: true,
		title: getCommonTranslation('MORE_DETAILS'),
		titleCollapse: true,
		itemId : 'moreDetailId',
		defaults : {
			labelAlign:'top',
		},
		style: {
			marginTop: '33px!important'
		},
		items:[{

			xtype : 'fieldcontainer',
			width: 'auto',
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			layout : {
				type : 'hbox'
			},
			items : [{
	     		xtype: 'customcombobox',
	     		name:'studentId',
	     		itemId:'studentId',
	     		store: Ext.create('Academia.store.coursetransaction.studentenrollment.studentenrollmentdetail.FacultyParamCourseStudentStore'),
	     		fieldLabel : getExaminationTranslation('STUDENTID_STUDENTNAME'),
	     		valueField: 'id',
	 			displayField: 'valueCode',
	 			queryParam:'name',
	     		minChars:3,
	     		typeAhead:false,
	     		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	     		enableKeyEvents  : 'true',
	     		hideTrigger:false,
	     		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	     		triggerAction: '',
	     		forceSelection:true,
	     		listConfig: {
	     			listeners: {
	 					beforeshow: function(picker) {
	 						picker.minWidth = picker.up('combobox').getSize().width;
	 					}
	 				},
	     			loadingText: getCommonTranslation('SEARCHING'),
	     			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	     			getInnerTpl: function() {
	     				return '<div class="search-item">' +
	     				'{value} / {code}' +
							'</div>';
	     			}
	     		}
	     	},{
				xtype: 'statusCombo',
				name: 'STATUS',
				itemId:'statusComboItemId',
				width:226,
				value:true,
				editable:false
			},{
				xtype : 'numberfield',
				name : 'absentAboveNumberOfSessions',
				itemId : 'absentAboveNumberOfSessions',
				fieldLabel : getCourseTxCommonTranslation('ABSENTS_ABOVE_NO_OF_DAYS_SESSIONS'),
				value : 0,
				minValue : 0,
				maxValue:365,
				mouseWheelEnabled :false,
				hideTrigger :true,
				allowExponential:false,
				allowDecimals:false
			}]
			},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype : 'numberfield',
				name : 'minAbsentPercentageSG',
				itemId : 'minAbsentPercentageSGId',
				fieldLabel : getCourseTxCommonTranslation('MIN_ABSENT_PERCENTAGE'),
				value : 0,
				minValue : 0,
				maxValue:100,
				mouseWheelEnabled :false,
				hideTrigger :true,
				allowExponential:false,
				allowDecimals:false,
				validator : function(val) {
					var attendancePercentageFromField = Ext.ComponentQuery.query('numberfield#attendancePercentageSGFromId')[0];
					var attendancePercentageToField = Ext.ComponentQuery.query('numberfield#attendancePercentageSGToId')[0];
					if (val > 0) {
						attendancePercentageFromField.setDisabled(true);
						attendancePercentageToField.setDisabled(true);
					} else if(val==0) {
						attendancePercentageFromField.setDisabled(false);
						attendancePercentageToField.setDisabled(false);
					}
					return true;
				}
			},{
				xtype : 'numberfield',
				name : 'attendancePercentageSGFrom',
				itemId : 'attendancePercentageSGFromId',
				fieldLabel : getCourseTxCommonTranslation('ATTENDANCE_PERCENTAGE_FROM'),
				minValue : 0,
				maxValue:100,
				mouseWheelEnabled :false,
				hideTrigger :true,
				allowExponential:false,
				allowDecimals:false,
				validator : function(minValue) {
					var minAbsentPercentageField = Ext.ComponentQuery.query('numberfield#minAbsentPercentageSGId')[0];
					var attendancePercentageToField = Ext.ComponentQuery.query('numberfield#attendancePercentageSGToId')[0];
					var maxValue = attendancePercentageToField.getValue();
					if (minValue > 0 && (maxValue > 0|| maxValue=="" || maxValue== null)) {
						minAbsentPercentageField.setDisabled(true);
						
					}else if(minValue=="" && (maxValue==""|| maxValue==null)) {
						minAbsentPercentageField.setDisabled(false);
					}
					if(maxValue!="" && maxValue!= null ){
						if(minValue <= maxValue){
							attendancePercentageToField.clearInvalid();
		 	   				 return true;
						}else{
							return getCourseTxCommonTranslation('ATTENDANCE_PERCENTAGE_FROM')+' should be less then '+getCourseTxCommonTranslation('ATTENDANCE_PERCENTAGE_TO');
						}
							
					}else{
						return true;
					}
				}
			},{
				xtype : 'numberfield',
				name : 'attendancePercentageSGTo',
				itemId : 'attendancePercentageSGToId',
				fieldLabel : getCourseTxCommonTranslation('ATTENDANCE_PERCENTAGE_TO'),
				minValue : 0,
				maxValue:100,
				mouseWheelEnabled :false,
				hideTrigger :true,
				allowExponential:false,
				allowDecimals:false,
				validator : function(maxVal) {
					var minPresentPercentageField = Ext.ComponentQuery.query('numberfield#minAbsentPercentageSGId')[0];
					var attendancePercentageFromField = Ext.ComponentQuery.query('numberfield#attendancePercentageSGFromId')[0];
					var minValue = attendancePercentageFromField.getValue();
					if (maxVal > 0 && (minValue > 0 || minValue=="" || minValue== null)) {
						minPresentPercentageField.setDisabled(true);
					} else if(maxVal=="" && (minValue==""|| minValue==null)) {
						minPresentPercentageField.setDisabled(false);
					}
					if(minValue!="" && minValue!= null &&
							maxVal!="" && maxVal!=null){
						if( maxVal>= minValue){
							attendancePercentageFromField.clearInvalid();
		 	   				 return true;
						}else{
							return getCourseTxCommonTranslation('ATTENDANCE_PERCENTAGE_TO')+' should be greater then '+getCourseTxCommonTranslation('ATTENDANCE_PERCENTAGE_FROM');
						}
							
					}else{
						return true;
					}
				}
			}]
    	 
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			itemId:'dateFieldsSG',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getCommonTranslation('START_DATE'),
				name : 'startDate',
				itemId : 'startDate',
				endDateField : 'tillDate',
				vtype : 'daterange',
				//maxValue:new Date(),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					},
					change: function(me, newValue, oldValue, eOpts) {
						if(!isNullOrEmpty(newValue))
						{
							var date = me.parseDate(newValue);
    						var startDate = me.up().down("#startDate");
    						var end = me.up().down("#tillDate");
    						var newDate = date.setMonth(date.getMonth()+6);
	                    	newDate = new Date(newDate);
	                    	end.setMaxValue(newDate);
	                    	startDate.isValid();
						}
					}
				}
			},{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getProgramandcourseTranslation('END_DATE'),
				name : 'tillDate',
				itemId : 'tillDate',
				startDateField : 'startDate',
				vtype : 'daterange',
				//maxValue:new Date(),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					},
					change: function(me, newValue, oldValue, eOpts) {
						if(!isNullOrEmpty(newValue))
						{
    						var date = me.parseDate(newValue);
    						var startDate = me.up().down("#startDate");
    						var endDate = me.up().down("#tillDate");
	                    	var newDate = date.setMonth(date.getMonth()-6);
	                    	newDate = new Date(newDate);
	                    	startDate.setMinValue(newDate);
	                    	endDate.isValid();
						}
					}
				}
			}]
		}]
	
	},{
		xtype: 'fieldcontainer',
		width: '100%',

		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			text: getCourseTxCommonTranslation('RESET'),
			itemId: 'resetBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE	        				
		}]
	}
	]
});