/**
 * @author Abhishek Chouhan
 * This component is used for to Assign Work Calendar   for Employee
 */
Ext.define('Academia.view.calendar.EmployeeWorkHoursWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.employeeworkhourswindow',
    modal: true,
    title: getCommonTranslation('WORK_HOUR_DETAILS'), //'Work Timing Configuration Details'
    border: true,
    autoScroll:true,
    height: '80%',
    cls:'horizontalScrollingFixed',
    width: '67%',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },

    items: [{
        xtype: 'form',
        plugins: "formlabelrequired",
        items: [{
            xtype: 'grid',
            itemId: 'employeeWorkHourId',
            border: true,
             viewConfig: {
                stripeRows: CONSTANTS.STRIPEROWS
            },
            features: [{
                ftype: 'summary',
                showSummaryRow: CONSTANTS.SHOW_SUMMARY_ROW
            }],
            store: 'calendar.StaffCalendarByCalendarIdStore',
            dockedItems: [/*{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: 'calendar.StaffCalendarByCalendarIdStore',
                    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
                    displayInfo: true
                }]
            }*/],
            columns: [{
                header: getCommonTranslation('DAY'),
                dataIndex: 'weekday',
                flex: 1.2,
                sortable: false,
                summaryRenderer: function(value, summaryData, dataIndex) {
                    return getCommonTranslation('TOTAL_HOURS');
                },
                renderer: function(value, meta, record) {
                    if (!isNullOrEmpty(value)) {
                        if (value == "SUNDAY") {
                            return getCommonTranslation("SUNDAY");
                        } else if (value == "MONDAY") {
                            return getCommonTranslation("MONDAY");
                        } else if (value == "TUESDAY") {
                            return getCommonTranslation("TUESDAY");
                        } else if (value == "WEDNESDAY") {
                            return getCommonTranslation("WEDNESDAY");
                        } else if (value == "THURSDAY") {
                            return getCommonTranslation("THURSDAY");
                        } else if (value == "FRIDAY") {
                            return getCommonTranslation("FRIDAY");
                        } else if (value == "SATURDAY") {
                            return getCommonTranslation("SATURDAY");
                        }
                    }
                }
            }, {
                header: getServiceRequestTranslation('IN_TIME'),
                dataIndex: 'startTime',
                flex: 1,
                sortable: true,
                renderer: function(time) {
                    return timeRender(time);
                }
            }, {
                header: getServiceRequestTranslation('OUT_TIME'),
                dataIndex: 'endTime',
                flex: 1,
                sortable: true,
                renderer: function(time) {
                    return timeRender(time);
                }
            }, {
                header: getCommonTranslation('TOTAL_HOURS'),
                dataIndex: 'totalHours',
                flex: 1,
                sortable: true,
                renderer: function(val) {
                	if (!isNullOrEmpty(val)) {
                		var d = new Date(val);
                        hoursArray = d.getHours();
                        minuteArray = d.getMinutes();
                        var totalTimeInMinutes = (val / 60000);
                        var minutes = 0,
                            hours = 0;
                        var hours = 0 + '' + d.getHours();
                        var minutes = 0 + '' + d.getMinutes();
                        var totalTime = hours.substr(-2) + ':' + minutes.substr(-2);
                        return totalTime;
                    } else {
                        return '';
                    }
                },
                align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
                summaryType: function(records) {
                    var hoursArray = 0,
                        minuteArray = 0;
                    for (i in records) {
                        var totalHours = records[i].get('totalHours');
                        if (!isNullOrEmpty(totalHours)) {
                            var d = new Date(totalHours);
                            hoursArray = hoursArray + d.getHours();
                            minuteArray = minuteArray + d.getMinutes();
                        }
                    }
                    if (minuteArray >= 60) {
                        var reminderMinute = (minuteArray % 60);
                        var minutesToHours = (minuteArray - reminderMinute) / 60;
                        hoursArray = hoursArray + minutesToHours;
                        minuteArray = reminderMinute;
                    }
                    if(minuteArray<10){
                    	minuteArray = '0'+minuteArray;
            		}
                    if(hoursArray<10){
                    	hoursArray = '0'+hoursArray;
                    }
                    return hoursArray + ':' + minuteArray;
                },
                summaryRenderer: function(value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
                    return value;
                }
            }, {
                header: getCommonTranslation('LATE_COMING_ALLOWED_TILL'),
                dataIndex: 'lateComingAllowedTill',
                flex: 1,
                sortable: true,
                renderer: function(time) {
                    return timeRender(time);
                }
            }, {
                header: getCommonTranslation('EARLY_GOING_ALLOWED_AFTER'),
                dataIndex: 'earlyGoingAllowedAfter',
                flex: 1,
                sortable: true,
                renderer: function(time) {
                    return timeRender(time);
                }
            }, {
                header: getCommonTranslation('MIN_HOURS_FOR_HALF_DAY'),
                dataIndex: 'minHoursOfHalfDay',
                flex: 1,
                sortable: true,
                renderer: function(val) {
                	if (!isNullOrEmpty(val)) {
                		var d = new Date(val);
                        hoursArray = d.getHours();
                        minuteArray = d.getMinutes();
                        var totalTimeInMinutes = (val / 60000);
                        var minutes = 0,
                            hours = 0;
                        var hours = 0 + '' + d.getHours();
                        var minutes = 0 + '' + d.getMinutes();
                        var totalTime = hours.substr(-2) + ':' + minutes.substr(-2);
                        return totalTime;
                    } else {
                        return '';
                    }
                },
            },{
                header: getCommonTranslation('MIN_HOURS_FOR_FULL_DAY'),
                dataIndex: 'minHoursOfFullDay',
                flex: 1,
                sortable: true,
                renderer: function(val) {
                	if (!isNullOrEmpty(val)) {
                		var d = new Date(val);
                        hoursArray = d.getHours();
                        minuteArray = d.getMinutes();
                        var totalTimeInMinutes = (val / 60000);
                        var minutes = 0,
                            hours = 0;
                        var hours = 0 + '' + d.getHours();
                        var minutes = 0 + '' + d.getMinutes();
                        var totalTime = hours.substr(-2) + ':' + minutes.substr(-2);
                        return totalTime;
                    } else {
                        return '';
                    }
                },
            } ]
        }]
    }]
});