/**
 * @author Saket.Puranik

 * This component is used for to show Facility details.
 */
Ext.define('Academia.view.calendar.entitylist.FacilityGrid',
		{
	extend : 'Ext.grid.Panel',
	alias : 'widget.facilitygrid',
	/* requires : [ ], */
	store : 'calendar.entitylist.FacilityStore',
	title : getCommonTranslation('FACILITY_TITLE'),//Facililties
	collapsible:false,
	border: true,
	autoScroll: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
	columns : [ {
		header : getCommonTranslation('FACILTY_CODE_HEADER'),//Facililty Code	
		dataIndex : 'code',
		align: 'center',
		sortable : false,	
		flex : .2
	}, {
		header : getCommonTranslation('FACILTY_NAME_HEADER'),//Facililty Name
		dataIndex : 'name',	
		align: 'center',
		sortable : false,	
		flex : .4
	}, {
		header : getCommonTranslation('FACILTY_TYPE_HEADER'),//Resource Type
		dataIndex : 'type',	
		align: 'center',
		sortable : false,	
		flex : .4
	}, {
		header : getCommonTranslation('FACILTY_STATUS_HEADER'),//Status
		dataIndex : 'status',
		align: 'center',
		sortable : false,	
		flex : .2			
	}],

	tbar : [
	        {
	        	xtype:'customcombobox',
	        	store:'calendar.entitylist.filters.LocationFilterStore',
	        	displayField:'value',
	        	valueField:'id',
	        	itemId:'comboLocation',
	    		editable:false,
	    		fieldLabel: 'Location',
	        	emptyText:'All Locations'	
	        },{
	        	xtype:'customcombobox',
	        	store:'calendar.entitylist.filters.ResourceTypeFilterStore',
	        	displayField:'value',
	        	valueField:'id',
	        	itemId:'comboResourceType',
	    		editable:false,
	    		fieldLabel: 'Resourse Type',
	        	emptyText:'All Resource Types'	
	        }],
	        dockedItems : [   {
				xtype : 'toolbar',
				dock : 'top',
				items : [ {  xtype: 'label',
			        text: getCommonTranslation('CALENDAR_FACILITY_GRID_TITLE'),
			        style: 'font-weight:bold;'} ]
			} ,{
	        	xtype : 'toolbar',
	        	dock : 'bottom',
	        	items : [ {
	        		xtype: 'custompagingtoolbar',
	                plugins:['pagesize'],
	        		store : 'calendar.entitylist.FacilityStore',
	        		emptyMsg : '<span id="ALPurposeGridId" style="margin-top: 60px !important">'+getCommonTranslation('EMPTY_FACILITY_MESSAGE')+'</span>',//No faculty to display
	        		displayInfo : true
	        	} ]
	        } ]
		});
