/**
 * @author Samarth.ashturkar
 * 
 * This component is used for to Special Days Grid.
 */
Ext.define('Academia.view.calendar.holidaysandspecialdaystabs.SpecialDaysGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.specialdaysgrid',
    title: getCommonTranslation('CALENDAR_SPECIAL_DAYS_DETAILS'),//Special Days Grid,
    border: true,
    autoScroll: true,
    viewConfig: {
        stripeRows: true
    },
    tbar: [{
		xtype : 'button',				
		itemId : 'btnAddSpecialDay',
		tooltip : getCommonTranslation('ADD'),//Add
		glyph: ICONGLYPH.ADDGLYPH
		//text : getCommonTranslation('ADD')
	},{
		xtype : 'button',				
		itemId : 'btnEditSpecialDay',
		tooltip : getCommonTranslation('EDIT'),//Edit
		glyph: ICONGLYPH.EDITGLYPH
		//text : getCommonTranslation('EDIT')
	},{
		xtype : 'button',				
		itemId : 'btnViewSpecialDay',
		tooltip : getCommonTranslation('VIEW'),//View
		iconCls: 'view-icon'
		//text : getCommonTranslation('VIEW')
	},{
		xtype : 'button',				
		itemId : 'btnDeleteSpecialDay',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),//Delete
		glyph: ICONGLYPH.DELETEGLYPH
		//text : getCommonTranslation('DELETE')
	}],
    columns: [{
		header : getCommonTranslation('CALENDAR_FROM_DATE'),//From date	
		dataIndex : 'startDate',
		align: 'center',
		sortable : true,	
	    flex : .2,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {
		header : getCommonTranslation('CALENDAR_TO_DATE'),//'To Date',
		dataIndex : 'endDate',	
		align: 'center',
		sortable : true,	
		flex : .2,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {
		header : getCommonTranslation('CALENDAR_OCCASION'),//Occasion
		dataIndex : 'description',	
		align: 'center',
		sortable : true,	
		flex : .3
	},{
		header : getCommonTranslation('CALENDAR_START_TIME'), // 'Start Time',
		dataIndex : 'startTime',	
		align: 'center',
		sortable : true,	
		flex : .2,
        renderer: function(time) {        	
            return timeRender(time);
        }
	},{
		header : getCommonTranslation('CALENDAR_END_TIME'), //'End Time',
		dataIndex : 'endTime',	
		align: 'center',
		sortable : true,	
		flex : .2,
        renderer: function(time) {
            return timeRender(time);
        }
	},{
		header : getCommonTranslation('CALENDAR_TIME_SLOT'),//'Time Slot (In mins)'
		dataIndex : 'slot',	
		align: 'center',
		sortable : true,	
		flex : .2,
		renderer: function(date) {
			return timeRender(date);
		}
	}],

    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });

        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.calendar.SpecialDaysGridStore');
    }

});