/**
 * @author Samarth.Ashturkar
 * This component is used for to Work Timing configuration Grid Details Window 
 */
Ext.define('Academia.view.calendar.worktimingconfiguration.WorkTimingConfigurationFormWindow',
		{
			extend : 'Ext.window.Window',
			alias : 'widget.worktimingconfigurationformwindow',			
			modal : true,		
			resizable:false,
			title : getCommonTranslation('CALENDAR_WORK_TIMING_CONFIGURATION_DETAILS'),//'Work Timing Configuration Details'
        	items : [{
				xtype: 'form',
				itemId:'workTimingConfigurationForm',
			    method : 'POST',
			    margin:0,
			    bodyPadding:'10 10 10 10',
			    plugins : "formlabelrequired",
				defaults:{
					labelAlign:'top'
				},
			    standardSubmit : false,
			    items : [{
				    	xtype : 'hidden',
						name : 'id'
			      },{
				    	xtype : 'hidden',
						name : 'dbId'
			      },{
				    	xtype : 'hidden',
						name : 'version'
			      },{
			    	  	xtype: 'customcombobox',
			            fieldLabel: getCommonTranslation('CALENDAR_DAY'),
			            name: 'weekday',
			            valueField: 'name',
			            displayField: 'value',
			            itemId: 'weekday',
			            store: 'common.DayWiseWeekComboStore',
			            editable: false,
			            allowBlank: false,
			            queryMode: 'local',
						width: 226
					}, {
						xtype : 'timefield',
						name : 'startTime',		
						itemId : 'startTime',			
						fieldLabel:getCommonTranslation('CALENDAR_START_TIME'),
						format: CONSTANTS.DISPLAY_TIME_FORMAT,
						vtype: 'timerange',
						endTimeField : 'endTime',
						width: 226,
						allowBlank:false,
						submitFormat : CONSTANTS.TIME_FORMAT_12hrs,
						listeners: {
							render: function(field) {
								return timeFormatRender(field);
							}
						}
					},{
						xtype : 'timefield',
						name : 'endTime',
						itemId : 'endTime',	
						fieldLabel : getCommonTranslation('CALENDAR_END_TIME'),
						format: CONSTANTS.DISPLAY_TIME_FORMAT,
						vtype: 'timerange',
						startTimeField : 'startTime',
						width: 226,
						allowBlank:false,
						submitFormat : CONSTANTS.TIME_FORMAT_12hrs,
						listeners: {
							render: function(field) {
								return timeFormatRender(field);
							}
						}
					},{
						xtype : 'numberfield',
						name : 'slot',	
						itemId : 'slot',			
						fieldLabel :getCommonTranslation('CALENDAR_TOTAL_TIME_SLOT'),
						allowBlank:false,
						minValue: 1,
						width: 226,
						maxValue: 1440
					},
					{
		        	xtype:'fieldcontainer',
		        	width:'100%',
		        	cls:'windowBtnPos', 
		        	style: {
		                marginLeft: '-3px'
		            },
		            items: [{
						xtype : 'button',				
						itemId:'btnSaveWorkTimingConfigurationForm',
						text : getCommonTranslation('SUBMIT'), //Submit
						ui: 'CustomBtnSubmit',
		                scale: CONSTANTS.BUTTONSIZE,
		                formBind : true
					},{
						xtype : 'button',
						itemId:'btnCancelWorkTimingConfigurationForm',
						text : getCommonTranslation('CANCEL'), //Cancel
						ui: 'CustomBtnCancel',
		                scale: CONSTANTS.BUTTONSIZE
					}]
			    }]
			}]	//end		
		});
