/**
 * @author seshagiri.k
 */
Ext.define('Academia.view.campaign.CampaignsCoverageForm', {
    extend: 'Ext.window.Window',
    alias: 'widget.campaignscoverageform',
    modal: true,
    resizable: false,
    width:380,    
    title: getCommonTranslation('TITLE_CAMPAIGN_COVERAGE'),
    id: 'formHiddenId',
    items: [{
        xtype: 'form',
        itemId: 'campaignFormWindow',
        method: 'POST',
        margin: 0,
        layout: {
            type: 'vbox'
        },
        defaults: {
            labelAlign: 'top',
            width: 330
        },
        standardSubmit: false,
        plugins: "formlabelrequired",
        items: [{
        	xtype: 'hidden',
        	name: 'isSaved'
        }, {
            xtype: 'hidden',
            name: 'id'
        }, {
        	xtype : 'customcombobox',
        	name : 'academyLocation',
        	itemId:'academyLocationId',
        	fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
//        	translationKey: 'ACADEMY_LOCATION',
        	store:'common.AcademyLocationNameSeparated',
        	valueField : 'id',
        	displayField : 'value',
        	allowBlank : false,
        	typeAhead: true,        	
        	forceSelection: true,        	
        },{
        	xtype: 'customcombobox',
            name: 'programId',
            itemId: 'programId',
            isEditMode:false,
            fieldLabel: getCommonTranslation('PROGRAM'),
//            translationKey: 'PROGRAM',
            store:'common.ProgramByAcademyLocationStore',
		    displayField:'value',
		    valueField:'id',
            maxLength:9999,
  			maxSelections :9999,
			forceSelection:true,
			typeAhead:true,
			allowBlank: false,
			editable:false,
			listConfig: {
				loadingText: getCommonTranslation("SEARCHING"),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
        },/*{
            xtype: 'customcombobox',
            name: 'programId',
            itemId: 'programId',
            fieldLabel: getCommonTranslation('PROGRAM'),           
            store:'common.ProgramByAcademyLocationStore',
		    displayField:'value',
		    valueField:'id',
            allowBlank: false,
            typeAhead: true,
            forceSelection: true

        }*/, {
        	xtype: 'customcombobox',
			name: 'userId',
			itemId: 'userId',
			store: 'campaign.UserByAcademyLocation',
			fieldLabel: getCommonTranslation('CAMPAIGN_CONTACT_PERSON'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'codeOrName',
			minChars:3,
			allowBlank: false,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
            forceSelection:true,
			  listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{value}' +
	                    '</div>';
	                }
	            }
		}, {
            xtype: 'textarea',
            name: 'coverageRemarks',
            fieldLabel: getCommonTranslation('REMARKS'),
            maxLength: 255,
            enforceMaxLength: true
        }, {
            layout: {
                type: 'hbox'
            },
            style:{
       		 marginLeft:'-3px'
       	 },
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SAVE'),
                itemId: 'campaignCoverageFormAddButtonId',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            },{
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                itemId: 'campaignCoverageFormClearButtonId',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }],
      listeners: {
         show: function (win) {
          var el = win.getEl();
          el.setOpacity(0);
          el.fadeIn({
            duration: 800
         });
      },
       beforeclose: function (win) {
        if (!win.shouldClose) {
            win.getEl().fadeOut({
                duration: 500,
                callback: function () {
                    win.shouldClose = true;
                    win.close();
                }
            });
        }
        return win.shouldClose ? true : false;
    }
}
    
});