/**
 * @author Niklesh Tiwane
 * 
 */
Ext.define('Academia.view.committee.committee.AlumniCommitteApplyToGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.alumnicommitteapplytogrid',
	store : 'committee.committee.AlumniCommitteeApplyToGridStore',
	title: getAlumni('SEARCHRESULTSGRIDHEADER'),
	border: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'committee.committee.AlumniCommitteeApplyToGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},
	{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns : [{
		header:  getAlumni("ACADEMY_LOCATION"),
		dataIndex: 'academyLocationName',
		flex:1
	},{
		header : getAlumni('PROGRAM_NAME'),
		dataIndex : 'programName',
		flex:1
	},{
		header : getAlumni('BATCH'),
		dataIndex : 'batchName',
		flex:1
	}]
});
