/**
 *  @author priyanshi Sharma
 */

Ext.define('Academia.view.committee.committee.CommitteeAddMappingATProgramBatchGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.committeeaddmappingatprogrambatchgrid',
	title : getCommonTranslation('BATCH'),
	store: Ext.create('Academia.store.committee.committee.CommitteeATProgramBatchMappingStore'),
	selType:'checkboxmodel',
	//cls:'removeGridHorizontalScrollCls',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	autoScroll: false,
	height:380,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask: false,
		deferEmptyText: false,
		emptyText: getCommonTranslation('NORESULTSNMESSAGE')
	},
	border: true,
	tbar: [{
		xtype:'button',
		itemId: 'nextButton',
		text:getCommonTranslation('NEXT'),
		tooltip: getCommonTranslation('NEXT')
	},{
		xtype: 'button',
		text: getCommonTranslation('RESET'),
		itemId: 'resetBtn',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'customcombobox',
		name: 'programBatchSearchCombo',
		itemId:'programBatchSearchCombo',
		store: 'committee.committee.CommitteeATProgramBatchComboStore',
		valueField: 'id',
		displayField: 'batchName',
		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		enableKeyEvents  : 'true',
		queryParam:'batchQry',
		queryMode: 'remote',
		width:226,
		typeAhead : true,
		forceSelection:true,
		hideTrigger:false,
		triggerAction: '',
		minChars:3,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}'  +
				'</div>';
			}
		}
	}],
	columns: [{
		header : getCommonTranslation('ACADEMIC_TERM'),
		dataIndex : 'academicTermName',
		flex : 1	 
	},{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex : 1	 
	},{
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex : 1	 
	}]
});