/**
 * @author Amit G
 */
Ext.define('Academia.view.committee.committee.CommitteeRequestGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.committeerequestgrid',
	store: 'committee.committee.CommitteeRequestReceivedGridStore',
	title: getCommonTranslation("LIST_OF_COMMITTEE_REQUEST_RECEIVED"),
	border: true,
	frame:false,
	refreshStoreData:true,
	selType:'checkboxmodel',
	style:{
		     "margin-bottom":"30px !important"
			    },
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'committeerequesttabstructure':1
		}
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'committee.committee.CommitteeRequestReceivedGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
        xtype: 'button',
        itemId: 'btnView',
        disabled:true,
        tooltip: getCommonTranslation('VIEW'),
        text: getCommonTranslation('VIEW')
	},{
        xtype: 'button',
        itemId: 'btnApproveGridItemId',
        tooltip: getCommonTranslation('APPROVE'),
        text: getCommonTranslation('APPROVE')
	}, {
		xtype: 'button',
        itemId: 'btnRejectGridItemId',
        tooltip: getCommonTranslation('REJECT'),
        text: getCommonTranslation('REJECT')
	}],
	columns: [{
		header:  getCommonTranslation("STUDENT_ID"),
		dataIndex:'studentId',
		flex:.1,
		renderer: function(rec) {
             return rec.code;
         }
	},{
		header:  getCommonTranslation("COMMITTEE_NAME"),
		dataIndex: 'committeeId',
		flex:.1,
		renderer: function(rec) {
            return rec.value;
        }
	},{
		header:  getCommonTranslation("MEMBERSHIP_TYPE"),
		dataIndex: 'membershipTypeId',
		flex:.1,
		renderer: function(rec) {
            return rec.value;
        }
	},{
		header:  getCommonTranslation("STUDENT_NAME"),
		dataIndex: 'studentId',
		flex:.1,
		renderer: function(rec) {
            return rec.value;
        }
	},{
		header:  getCommonTranslation('PROGRAM'),
		dataIndex: 'programList',
		flex:.1
	},{
		header:  getCommonTranslation('BATCH'),
		dataIndex: 'intakeList',
		flex:.1
	},{
		header:  getCommonTranslation('SEAT_TYPE'),
		dataIndex: 'seatTypeList',
		flex:.1
	},{
		header:  getCommonTranslation('STATUS'),
		dataIndex: 'approvalStatus',
		flex:.1,
		renderer : function(value, metadata, record) {
			var val = '';
			if(value == 'PENDING') {
				val = 'Pending';
			}else if(value == 'APPROVED') {
				val = 'Approved';
			}else if(value == 'CANCELLED') {
				val = 'Cancelled';
			}else if(value == 'REJECTED'){
				val = 'Rejected';
			}
			return val;
		}
	},{
		header:  getCommonTranslation('ASSIGNEE'),
		dataIndex: 'requestAssignTo',
		flex:.1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.requestAssignTo)){
				return record.data.requestAssignTo.value;
			}else
				{
				return "Auto";
				}
		}
	}]
});
