Ext.define('Academia.view.common.NestedForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.nestedForm',

    formValueField: null,

    setValues: function(values) {
        var me = this,
            v, vLen, val;

        function setVal(fieldId, val) {
            var item = me.finditems(fieldId);
            if (item) {
                item.getForm().setValues(val);
            }
        }


        // Suspend here because setting the value on a field could trigger
        // a layout, for example if an error gets set, or it's a display field
        Ext.suspendLayouts();
        if (Ext.isArray(values)) {
            // array of objects
            vLen = values.length;

            for (v = 0; v < vLen; v++) {
                val = values[v];
                setVal(val.searchParam, val);
            }
        } else {
            // object hash
            Ext.iterate(values, setVal);
        }
        Ext.resumeLayouts(true);
        return this;
    },


    finditems: function(id) {
        return this.items.findBy(function(f) {
            return f.id === id || f.name === id;
        });
    },

    getValues: function() {
        var values = [];
        this.items.each(function(obj) {
        	if((typeof obj.getValues != "undefined") && obj.submitValue!=false)
        		values.push(obj.getValues());
        });
        return values;
    }

});