/**
 * @author Rohit Thadani
 */
Ext.define('Academia.view.common.PersonHostelRequirementForm', {
	//extend:'Academia.view.common.CustomFieldForm',
	extend:'Academia.view.common.IdGeneratorCustomForm',
    customFieldEntity:CONSTANTS.APPLICANT_HOSTEL_REQUIREMENT_CF_DATA,
    alias: 'widget.personhostelrequirementform',
    border: false,
    frame: true,
    autoScroll:true,
    title: getPersonModuleTranslation('HOSTEL_PERSONAL_REQUIREMENTS'),
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        itemId: 'idItemId',
        name: 'id'
    },{
        xtype: 'hidden',
        name: 'version'
    }, {
    	xtype: 'fieldset',
		title: getAdmissionTranslation('HOSTEL_DETAILS'),
		style: {marginTop: '30px !important'},
		itemId:'hostelRequiredDetailsItemId',
		name: 'hostelRequiredDetails',
		items:[{
			xtype:'panel',
			layout:'vbox',
			cls: 'panelNoSpace',
			items:[{
		        xtype: 'fieldcontainer',
		        width: 'auto',
		        defaults: {
		            labelAlign: 'top',
		            width: 226
		        },
		        layout: 'hbox',
		        items: [{
			    		xtype: 'checkboxfield',
			    		//name: 'whetherHostelRequired',
			    		name: 'whetherHostelApplicable',
			    		boxLabel: getPersonModuleTranslation('IS_HOSTEL_REQUIRED'),
			    		itemId:'isHostelRequired',
			    		inputValue : true,
			    		uncheckedValue: false,
			    		labelSeparator : '',
			    		style: {
			    			//marginTop: '25px'
			    		}
				}, {
						xtype: 'checkboxfield',
						name: 'whetherApplicantWaiting',
						boxLabel: getCommonTranslation('APPLICANT_WAITING_LIST'),
						itemId: 'whetherApplicantWaiting',
						inputValue: true,
						uncheckedValue: false,
						labelSeparator: '',
					}, {
						xtype: 'customcombobox',
						fieldLabel: getCommonTranslation('WAITING_LIST_SETUP'),
						name: 'waitingListSetup',
						itemId: 'waitingListSetupCombo',
						store: Ext.create('Academia.store.admission.applications.applicantProfileBase.ApplicantHostelWaitingListStore'),
						displayField: 'value',
						valueField: 'id',
						forceSelection: true,
						autoloadStore: false,
					}]
				},{
			         xtype: 'fieldcontainer',
			         itemId:'hostelFieldsContainer1',
			         width: 'auto',
			         style: {
			    			height : '80px'
			    		},
			         defaults: {
			             labelAlign: 'top',
			             width: 226
			         },
			         layout: 'hbox',
			         items: [{
			             xtype: 'textfield',
			             name: 'dietaryRequirements',
			             itemId: 'dietaryRequirementsItemId',
			             fieldLabel: getPersonModuleTranslation('WHETHER_DIETARY_REQUIREMENTS'),
			             labelSeparator : '',
			             maxLength: 255
			         }, {
			             xtype: 'textfield',
			             name: 'foodAllergies',
			             itemId: 'foodAllergiesItemId',
			             fieldLabel: getPersonModuleTranslation('WHETHER_FOOD_ALLERGIC'),
			             labelSeparator : '',
			             maxLength: 255
			         }, {
			             xtype: 'textfield',
			             name: 'sleepingDisorder',
			             itemId: 'sleepingDisorderItemId',
			             fieldLabel: getPersonModuleTranslation('WHETHER_SLEEPING_DISORDER'),
			             labelSeparator : '',
			             maxLength: 255
			         }]
			     },{
			         xtype: 'fieldcontainer',
			         itemId:'hostelFieldsContainer2',
			         width: 'auto',
			         defaults: {
			             labelAlign: 'top',
			             width: 226
			         },
			         layout: 'hbox',
			         items: [{
			             xtype: 'textfield',
			             name: 'anyMedicalNeedsOrSomething',
			             itemId: 'anyMedicalNeedsOrSomethingItemId',
			             fieldLabel: getPersonModuleTranslation('WHETHER_MED_EMO_PHYSICAL_NEED'),
			             labelSeparator : '',
			             maxLength: 255
			         }]
			     
			     }, {
			         xtype: 'panel',
			         itemId: 'hostelPreferencePanel',
			         style: {
			        	 marginLeft: '0px',
		             },
			         items: [{
			             xtype: 'fieldcontainer',
			             width: 'auto',
				         defaults: {
				             labelAlign: 'top',
				             width: 220
				         },
			             layout: {
			                 type: 'hbox',
			                 align: 'bottom'
			             },
			            
			             items: [{
			                 xtype: 'customcombobox',
			     			fieldLabel: getAdmissionTranslation('LOCATION'),
			                 name: 'academyLocationCombo',
			                 itemId:'academyLocationCombo',
			                 store:Ext.create('Academia.store.organization.academylocations.LocationCustomSearchStore'),
			                 displayField: 'value',
			                 valueField: 'id',
			                 forceSelection:true,
			                 typeAhead : false,
			                 height:'auto',
				     		 autoloadStore: false,
			             },{
				             xtype: 'customcombobox',
				             name: 'applicantHostelDetails1',
				             labelSeparator : '',
				             addAllSelector: false,
				             itemId: 'applicantHostelDetailsId1',
				             fieldLabel: getCommonTranslation('HOSTEL_CHOICE_FIRST_PREFERENCE'),
				     		 store: Ext.create('Academia.store.servicerequest.servicerequestsettings.AssigneeApproverHostelLocationWiseStore'),
				     		 displayField: 'hostelName',
			                 valueField: 'hostelId',
				     		 forceSelection:true,
				     		queryMode: 'local',
				     		 typeAhead:false,
				     		 cls:'multiBrandCampusCls',
				     		 height:'auto',
				     		 autoloadStore: false,
				     		 listConfig :{         
								listeners :{ 
									beforeshow: function(picker) {
			        					picker.width = picker.up('combobox').getSize().width;
			        				},
			        				beforeselect : function(combo,record,index,opts) {
			        					if (combo.getCount() == 3) {
			        						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('HOSTEL_SELECTION_EXCEEDS_MSG'));
			                                return false;
		                              }
		                          },
		                      },
							}
				         },{
				             xtype: 'customcombobox',
				             name: 'applicantHostelDetails2',
				             addAllSelector: false,
				             itemId: 'applicantHostelDetailsId2',
				             fieldLabel: getCommonTranslation('HOSTEL_CHOICE_SECOND_PREFERENCE'),
				     		 store: Ext.create('Academia.store.servicerequest.servicerequestsettings.AssigneeApproverHostelLocationWiseStore'),
				     		 displayField: 'hostelName',
			                 valueField: 'hostelId',
				     		 forceSelection:true,
				     		 typeAhead:false,
				     		 labelSeparator : '',
				     		 cls:'multiBrandCampusCls',
				     		 height:'auto',
				     		 autoloadStore: false,
				     		queryMode: 'local',
				     		 listConfig :{         
								listeners :{ 
									beforeshow: function(picker) {
			        					picker.width = picker.up('combobox').getSize().width;
			        				},
			        				beforeselect : function(combo,record,index,opts) {
			        					if (combo.getCount() == 3) {
			        						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('HOSTEL_SELECTION_EXCEEDS_MSG'));
			                                return false;
		                              }
		                          },
		                      },
							}
				         }, {
				             xtype: 'customcombobox',
				             name: 'applicantHostelDetails3',
				             addAllSelector: false,
				            itemId: 'applicantHostelDetailsId3',
				             fieldLabel: getCommonTranslation('HOSTEL_CHOICE_THIRD_PREFERENCE'),
				     		 store: Ext.create('Academia.store.servicerequest.servicerequestsettings.AssigneeApproverHostelLocationWiseStore'),
				     		 displayField: 'hostelName',
			                 valueField: 'hostelId',
				     		 forceSelection:true,
				     		 typeAhead:false,
				     		 cls:'multiBrandCampusCls',
				     		 height:'auto',
				     		 autoloadStore: false,
				     		queryMode: 'local',
				     		 listConfig :{         
								listeners :{ 
									beforeshow: function(picker) {
			        					picker.width = picker.up('combobox').getSize().width;
			        				},
			        				beforeselect : function(combo,record,index,opts) {
			        					if (combo.getCount() == 3) {
			        						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('HOSTEL_SELECTION_EXCEEDS_MSG'));
			                                return false;
		                              }
		                          },
		                      },
							}
				         },{
			         		xtype : 'button',
			         		itemId: 'btnAddHostelPreference0',
			         		cls: 'CustomBodyBtnSettings',
			 				text: getCommonTranslation('ADDBUTTONTEXT'),
			 				tooltip: getCommonTranslation('ADD')
			         	}]
			         }]
			     } ,{
			         xtype: 'fieldcontainer',
			         itemId:'hostelFieldsContainer3',
			         width: 'auto',
			         defaults: {
			             labelAlign: 'top',
			             width: 226
			         },
			         layout: 'hbox',
			         items: [/*{
			             xtype: 'nestedJsonCombo',
			             name: 'applicantHostelDetails3',
			             addAllSelector: false,
			             itemId: 'applicantHostelDetailsId3',
			             fieldLabel: getCommonTranslation('HOSTEL_CHOICE_THIRD_PREFERENCE'),
			     		 store: Ext.create('Academia.store.servicerequest.servicerequestsettings.AssigneeApproverHostelGridStore'),
			     		 valueField : 'id',
			     		 displayField : 'value',
			     		 forceSelection:true,
			     		 typeAhead:false,
			     		 cls:'multiBrandCampusCls',
			     		 height:'auto',
			     		 autoloadStore: false,
			     		 listConfig :{         
							listeners :{ 
								beforeshow: function(picker) {
		        					picker.width = picker.up('combobox').getSize().width;
		        				},
		        				beforeselect : function(combo,record,index,opts) {
		        					if (combo.getCount() == 3) {
		        						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('HOSTEL_SELECTION_EXCEEDS_MSG'));
		                                return false;
	                              }
	                          },
	                      },
						}
			         },*/ {
			             xtype: 'radiogroup',
			             name: 'tempAccommondation',
			             itemId: 'tempAccommondationId',
			             height: 80,
			             fieldLabel: getCommonTranslation('TEMPORARY_ACCOMMODATION_NEEDED'),
			             style: {
		                     marginTop: '5px'
		                 },
		                 defaults: {
		                     flex: .1
		                 },
		                 items: [{
		                	 boxLabel: getCommonTranslation('YES'),
		                	 name: 'tempAccommondationType',
		                	 inputValue: true
		                 }, {
			                 boxLabel: getCommonTranslation('No'),
			                 name: 'tempAccommondationType',
			                 inputValue: false,
			                 checked: true
			             }]
			         }, {
				             xtype: 'radiogroup',
				             name: 'applyForWaitingListType',
				             itemId: 'applyForWaitingListTypeId',
				             height: 80,
				             fieldLabel: getCommonTranslation('APPLY_FOR_WAITING_LIST'),
				             style: {
			                     marginTop: '5px'
			                 },
			                 defaults: {
			                     flex: .1
			                 },
			                 items: [{
			                	 boxLabel: getCommonTranslation('YES'),
			                	 name: 'applyForWaitingList',
			                	 inputValue: true
			                 }, {
				                 boxLabel: getCommonTranslation('No'),
				                 name: 'applyForWaitingList',
				                 inputValue: false,
				                 checked: true
				             }]
			         }, {
			        	 
			        	 xtype: 'customcombobox',
			        	 name: 'waitingListType',
				         itemId: 'waitingListTypeId',
				         fieldLabel: getCommonTranslation('SELECT_WAITING_LIST_TYPE'),
				     	 store: Ext.create('Academia.store.admission.applications.applicantProfileBase.HostelWaitingListForApplicantStore'),
				     	 displayField: 'value',
			             valueField: 'id',
			             editable : false,
			             allowBlank:true,
			             hideTrigger:false,
			             triggerAction: 'all',
			             forceSelection:true,
			             disabled:true,
				     	 height:'auto',
				     	 listConfig :{         
							listeners :{ 
								beforeshow: function(picker) {
			        				picker.width = picker.up('combobox').getSize().width;
			        			}
							}
				     	}
			        }]
			     
			     }
			     
			     ]
		}
		]
    }
    ,{
        xtype: 'fieldcontainer',
        style: {
            marginLeft: '-2px',
            marginTop: '20px'
        },
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});