/**
 * @author pritam.patil
 * this is Quick search Form Of Termination 
 */
Ext.define('Academia.view.completion.completionlist.TerminationQuickSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.terminationquicksearchform',
    cls:'customSearchPanel',
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getCompletionModuleTranslation('STUDENT_ID'),            
            name: 'STUDENT_ID',
            msgTarget: 'qtip'
                       
        }, {
            xtype: 'customcombobox',
            fieldLabel: getCompletionModuleTranslation('SELECT_NAME'),            
            store: 'common.SelectNameComboStore',
            editable: false,
            name: 'selectedNameField',
            itemId: 'selectedNameField',
            valueField: 'id',
            displayField: 'value',
            value: 'FIRST_NAME',
            queryMode : 'local'
        },{
            xtype: 'textfield',
            fieldLabel: getCompletionModuleTranslation('FIRST_NAME'),            
            itemId: 'selectedName',
            name: 'FIRST_NAME',
            msgTarget: 'qtip'
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            name: 'PROGRAM',
            store: 'facilitiesresources.resourcebooking.AllProgramsStore',
            fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
            itemId :'programId',
            valueField: 'id',
            displayField: 'valueCode',
            typeAhead: true,
            forceSelection: true,
            triggerAction: 'all',
            queryParam:'programName',
            minChars:3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	 			listConfig: {
	 				listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	 				loadingText: getCommonTranslation('SEARCHING'),
	 				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	 				getInnerTpl: function() {
	 					return '<div class="search-item">' +
	 					'{value}' +
	 					'</div>';
	 				}
	 			}
        }, {
            xtype: 'customcombobox',
            name: 'BATCH',
            fieldLabel: getCompletionModuleTranslation('BATCH'),
            disabled: true,
            editable: false,   
            store: 'facilitiesresources.resourcebooking.AllBatchesStore',
            displayField: 'value',
            valueField: 'id',
            itemId :'batchId'
        },{
            xtype: 'customcombobox',
            name: 'SECTION',
            store: 'completion.completionform.SectionByBatch',
            fieldLabel: getCompletionModuleTranslation('SECTION'),
            editable: false,   
            disabled: true,
            valueField: 'id',
            displayField: 'value',
            itemId :'sectionId'
        }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        itemId : 'fieldContainer',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
        	xtype: 'customcombobox',
            name: 'TERMINATION_REASON',
            fieldLabel: getCompletionModuleTranslation('TERMINATION_REASON'),
            itemId: 'terminationReason',
            editable: false,            
            store: 'servicerequest.TerminationReasons',
            displayField: 'value',
            valueField: 'id',
            listeners:{
            	beforerender: function(combo){
            		var comboStore = 'servicerequest.TerminationReasons';
            		if(Ext.isDefined(combo.up("temporaryterminationpanel"))){
            			comboStore = 'servicerequest.DebarmentReasons';
            		}
            		combo.bindStore(comboStore);
            	}
            }
           },{
            xtype: 'customcombobox',
            name: 'STATUS',
            fieldLabel: getCompletionModuleTranslation('STATUS'),
            itemId: 'status',
            editable: false,
            store: 'completion.completionform.TerminationStatus',
            displayField: 'value',
            valueField: 'id',
            queryMode : 'local',
            msgTarget: 'qtip'
        }]
    },{
        xtype: 'fieldcontainer',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'datefield',
            fieldLabel: getCompletionModuleTranslation('FROM_DATE'),
            name: 'FROM_DATE',
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            itemId: 'fromdate',
            vtype: 'daterange',
            endDateField: 'todate',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
        }, {
            xtype: 'datefield',
            fieldLabel: getCompletionModuleTranslation('TO_DATE'),
            name: 'TO_DATE',
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            itemId: 'todate',
            vtype: 'daterange',
            startDateField: 'fromdate',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
        }]
    },{
            xtype: 'fieldcontainer',
            width: '100%',
            itemId : 'checkBoxFieldContainer',
    		visible: true,
            layout: {
                type: 'hbox'
            },
            defaultType: 'checkboxfield',
            items:  [{
                boxLabel  : getCompletionModuleTranslation('PENDING_PAYMENT'),
                name      : 'IS_PAYMENT_PENDING',
                inputValue: true,
                uncheckedValue:""
            }, {
                boxLabel  : getCompletionModuleTranslation('PENDING_DOCUMENT'),
                name      : 'IS_DOCUMENT_PENDING',
                inputValue: true,
                uncheckedValue:""
            }, {
                boxLabel  : getCompletionModuleTranslation('REFUND_PAYMENT'),
                name      : 'IS_REFUND_PENDING',
                inputValue: true,
                uncheckedValue:""
            },{
                boxLabel  : getCompletionModuleTranslation('RETURN_DOCUMENT'),
                name      : 'IS_DOCUMENT_RETURNED',
                inputValue: true,
                uncheckedValue:""
            }, {
                boxLabel  : getCompletionModuleTranslation('PENDING_CERTIFICATE'),
                name      : 'CERTIFICATE_STATUS',
                inputValue: 'PENDING',
                uncheckedValue:""
            }
        ]
    } ,{
        xtype: 'fieldcontainer',
        width: '100%',
        items: [{
            xtype: 'button',
            text: getCompletionModuleTranslation('SEARCH'),
            itemId: 'terminationFindButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        },{
            xtype: 'button',
            text: getCompletionModuleTranslation('CLEAR_SEARCH'),
            itemId: 'terminationClearSearch',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});
