/**
 * @author pritam.patil
 * this is Quick search Form Of Withdraw Program 
 */
Ext.define('Academia.view.completion.completionlist.WithdrawProgramQuickSearchForm', {
    extend:'Academia.view.common.DynamicFieldForm',
    alias: 'widget.withdrawprogramquicksearchform',
    frame : false,
    cls:'customSearchPanel',
   // title: getCompletionModuleTranslation('QUICK_SEARCH'),
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getCompletionModuleTranslation('ADMISSION_ID'),
            
            name: 'ADMISSION_ID'
        }, {
            xtype: 'textfield', 
            fieldLabel: getCompletionModuleTranslation('STUDENT_ID'),
            
            name: 'STUDENT_ID'
        }, {
            xtype: 'customcombobox',
            fieldLabel: getCompletionModuleTranslation('SELECT_NAME'),
            store: 'common.SelectNameComboStore',
            editable: false,
            name: 'selectedNameField',
            itemId: 'selectedNameField',
            valueField: 'id',
            queryMode : 'local',
            displayField: 'value',
            value: 'FIRST_NAME'
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getCompletionModuleTranslation('FIRST_NAME'),
            itemId: 'selectedName',
            name: 'STUDENT_NAME'
        },
        {
            xtype: 'customcombobox',
            name: 'PROGRAM',
            store: 'facilitiesresources.resourcebooking.AllProgramsStore',
            fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
            itemId :'programId',
            valueField: 'id',
            displayField: 'valueCode',
            typeAhead: true,
            forceSelection: true,
            triggerAction: 'all',
            queryParam:'programName',
            minChars:3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	 			listConfig: {
	 				listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	 				loadingText: getCommonTranslation('SEARCHING'),
	 				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	 				getInnerTpl: function() {
	 					return '<div class="search-item">' +
	 					'{value}' +
	 					'</div>';
	 				}
	 			}
        }, {
            xtype: 'customcombobox',
            name: 'BATCH',
            editable: false,
            fieldLabel: getCompletionModuleTranslation('BATCH'),
            store: 'facilitiesresources.resourcebooking.AllBatchesStore',
            displayField: 'value',
            valueField: 'id',
            itemId :'batchId',
            disabled : true
        }]
    },{

        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            name: 'SECTION',
            store: 'completion.completionform.SectionByBatch',
            fieldLabel: getCompletionModuleTranslation('SECTION'),
            editable: false,
            valueField: 'id',
            displayField: 'value',
            itemId :'sectionId',
            disabled : true 
        }, {
            xtype: 'customcombobox',
            name: 'ProgramCoordinator',
            itemId: 'ProgramCoordinatorId',
            fieldLabel: getCompletionModuleTranslation('PPROGRAM_COORDINATOR'),            
            store: 'completion.completionform.ProgramCoordinatorStore',
            valueField: 'id',
            displayField: 'value',
            queryParam:'qry',
            queryMode : 'remote',
            minChars:3,
            hidden:true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	 			listConfig: {
	 				listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	 				loadingText: getCommonTranslation('SEARCHING'),
	 				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	 				getInnerTpl: function() {
	 					return '<div class="search-item">' +
	 					'{value}' +
	 					'</div>';
	 				}
	 			}
        },{
            xtype: 'customcombobox',
            name: 'STATUS',
            fieldLabel: getCompletionModuleTranslation('STATUS'),
            itemId: 'status',
            editable: false,
            store: 'completion.completionform.CompletionStatus',
            displayField: 'value',
            valueField: 'id',
            queryMode : 'local'
        },{
        	xtype: 'customcombobox',
            name: 'WITHDRWAL_REASON',
            fieldLabel: getCompletionModuleTranslation('WITHDRWAL_REASON'),
            itemId: 'withdrawalReason',
            editable: false,
            store: 'completion.completionform.WithdrawReasons',
            displayField: 'value',
            valueField: 'id'
         }]
    },{
        xtype: 'fieldcontainer',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'datefield',
            fieldLabel: getCompletionModuleTranslation('FROM_DATE'),
            name: 'FROM_DATE',
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            itemId: 'fromdate',
            vtype: 'daterange',
            endDateField: 'todate',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
        }, {
            xtype: 'datefield',
            fieldLabel: getCompletionModuleTranslation('TO_DATE'),
            name: 'TO_DATE',
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            itemId: 'todate',
            vtype: 'daterange',
            startDateField: 'fromdate',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
        }]
    },{
            xtype: 'fieldcontainer',
            width: '100%',
            layout: {
                type: 'hbox'
            },
            defaultType: 'checkboxfield',
            items: [{
                         boxLabel  : getCompletionModuleTranslation('PENDING_PAYMENT'),
                         name      : 'IS_PAYMENT_PENDING',
                         inputValue: true,
                         uncheckedValue:""
                     }, {
                         boxLabel  : getCompletionModuleTranslation('PENDING_DOCUMENT'),
                         name      : 'IS_DOCUMENT_PENDING',
                         inputValue: true,
                         uncheckedValue:""
                     }, {
                         boxLabel  : getCompletionModuleTranslation('REFUND_PAYMENT'),
                         name      : 'IS_REFUND_PENDING',
                         inputValue: true,
                         uncheckedValue:""
                     },{
                         boxLabel  : getCompletionModuleTranslation('RETURN_DOCUMENT'),
                         name      : 'IS_DOCUMENT_RETURNED',
                         inputValue: true,
                         uncheckedValue:""
                     }, {
                         boxLabel  : getCompletionModuleTranslation('PENDING_CERTIFICATE'),
                         name      : 'CERTIFICATE_STATUS',
                         inputValue: 'PENDING',
                         uncheckedValue:""
                     }
                 ]
    } ,{
        xtype: 'fieldcontainer',
        width: '100%',
        items: [{
            xtype: 'button',
            text: getCompletionModuleTranslation('SEARCH'),
            itemId: 'passingOutFindButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
			formBind: true,  
            scale: CONSTANTS.BUTTONSIZE
        },{
            xtype: 'button',
            text: getCompletionModuleTranslation('CLEAR_SEARCH'),
            itemId: 'passingOutClearSearch',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});