/**
 * @author sachin.bangar
 * This form is used to map CheckList Item/Certificate with Transaction Type
 */
Ext.define('Academia.view.completion.setup.MapChecklistWithTransactionTypeForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.mapchecklistwithtransactiontypeform',
    border : false,
    frame : false,
    //bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL} ,	
    plugins: "formlabelrequired",
    initComponent: function() {
        var this$ = this;     

        var store = this$.buildStore();        
        
        this$.items = [{
            xtype: 'hidden',
            itemId: 'map_hidden_field',
            name: 'id'
        }, {
            xtype: 'hidden',
            name: 'version'
        }, {
            xtype: 'nestedJsonCombo',
            itemId : 'checklistTransactionTypeCombo',
            labelWidth : 150,
            width : 376,
            style :{
            	marginLeft : '10px',
            	marginTop : '25px'
            },
            fieldLabel: getCompletionModuleTranslation('TRANSACTION_TYPE'),            
            store : 'completion.setup.TransactionTypesExceptTempTermination',
            valueField: 'id',
            displayField: 'translatedCode',  
            name: 'transactionType',
            allowBlank: false,
            editable: false
        }, {
            xtype: 'itemselector',
            itemId: 'mapChecklistItemSelector',
            labelAlign: 'top',
            name: 'checklistItems',
            width : 700,
            maxHeight:400,
            style : {
            	marginTop: '25px'
            },
            allowBlank: false,
            autoScroll:true,
            imagePath: '../ux/css/images/',
            store : store,
            displayField: 'value',
            valueField: 'id',
            editable: false,
            queryMode : 'local',
            fromTitle: getCompletionModuleTranslation('AVAILABLE_CHECKLIST_ITEM'),
            toTitle: getCompletionModuleTranslation('APPLICABLE_CHECKLIST_ITEM'),
            delimiter: null,
            buttons: ['top', 'add', 'remove', 'bottom']
    	},{
            xtype: 'fieldcontainer',
            width: '100%',
            style : {
            	marginLeft : '8px',
            		
            },
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SAVE'),
                itemId: 'submitButtonId',
                buttonAlign: 'right',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true,
            }]
        }];
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.completion.setup.CheckListItemStore');
    }
});