/**
 * @author Akshay Sharma
 */
Ext.define('Academia.view.course.NoOfVariantGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.noofvariantgrid',
	autoScroll: false,
	border: true,
	title:getProgramandcourseTranslation('ASSOCIATED_COURSE_VARIANTS'),
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	store : 'course.NoOfCourseVariantAssoGridStore',
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'course.NoOfCourseVariantAssoGridStore',
			displayInfo : true
		} ]
	} ],
	initComponent: function() {
        var grid=this;    
        grid.addExportToolBarItems(grid,false);
        this.callParent(arguments); 
 },
	columns : [{
		header :  getCommonTranslation('COURSE_VARIANT_CODE'),
		dataIndex : 'courseVariantCode',
		flex : 1,
		hidden:true
		 
	}, {
		header : getProgramandcourseTranslation('COURSE_VARIANT_DESCRIPTION'),
		dataIndex : 'courseVariantName',
		flex : 1,
		hidden:true	
	},{
		header : getCommonTranslation('ACADEMYLOCATION'),
		dataIndex : 'academyLocationName',
		flex : 1,
		hidden:true	
	},{
		header : getCommonTranslation('PROGRAM_NAME'),
		dataIndex : 'programName',
		flex : 1,
		hidden:true
		 
	}, {
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batch',
		flex : 1,
		hidden:true	
		
	}, {
		header : getCommonTranslation('SECTION'),
		dataIndex : 'section',
		flex : 1,
		hidden:true
	}, {
		header : getCommonTranslation('PROGRAM_PERIODS'),
		dataIndex : 'programPeriod',
		flex : 1,
		hidden:true
		
	}, {
		header : getCommonTranslation('OPTIONAL_MENDATORY'),
		dataIndex : 'optionalOrMandatory',
		flex : 1,
		hidden:true,
		renderer : function(value){
			if(value){
				return getCommonTranslation('OPTIONAL');
			}else{
				return getCommonTranslation('MANDATORY');
			}
		}
	},{
		header : getCommonTranslation('PROGRAMS_ASSOCIATED'),
		dataIndex : 'totalParamterized',
		flex : 1,
		hidden:true,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	}]
});
