/**
 * By Utsav 
 */
Ext.define('Academia.view.course.courseEquivalence.CourseEquivalenceForm', {
    extend: 'Ext.window.Window',
    alias: 'widget.courseequivalenceform',
    modal: true,
    resizable: true,
    title: getCommonTranslation('COURSE_EQUIVANENCE'),
    //    translationKey:'COURSE_EQUIVANENCE',
    items: [{
        xtype: 'idgeneratorcustomformwin',
        layout: {
            type: 'vbox'
        },
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        plugins: "formlabelrequired",
        standardSubmit: false,
        items: [{
                xtype: 'hidden',
                name: 'id'
            },

            {
                xtype: 'fieldcontainer',
                layout: {
                    type: 'hbox'
                },
                defaults: {
                    width: 226,
                    labelAlign: 'top'
                },
                width: 'auto',
                items: [{
                        xtype: 'customcombobox',
                        name: 'courseEquivalenceAlias',
                        fieldLabel: getCommonTranslation('TYPE'),
                        store: 'course.courseequivalence.CourseEquivalenceAliasStore',
                        valueField: 'name',
                        displayField: 'value',
                        itemId: 'courseEquivalenceAlias',
                        editable: false,
                        allowBlank: false
                    },
                    {
                        xtype: 'customcombobox',
                        name: 'equivalentCourseCode',
                        fieldLabel: getCommonTranslation('EQUIVALENT_COURSE_CODE'),
                        //			translationKey:'EQUIVALENT_COURSE_CODE',
                        store: 'course.courseequivalence.CourseExceptCurrentEquivalenceStore',
                        valueField: 'id',
                        displayField: 'code',
                        itemId: 'equivalentCourseCode',
                        editable: true,
                        allowBlank: false,
                        queryParam: 'courseName',
                        minChars: 3,
                        emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                        listConfig: {
                            listeners: {
                                beforeshow: function(picker) {
                                    picker.minWidth = picker.up('combobox').getSize().width;
                                }
                            },
                            loadingText: getCommonTranslation('SEARCHING'),
                            emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                            getInnerTpl: function() {
                                return '<div class="search-item">' +
                                    '{code} / {value}' +
                                    '</div>';
                            }
                        }

                    }
                ]
            }, {
                xtype: 'fieldcontainer',
                layout: {
                    type: 'hbox'
                },
                defaults: {
                    width: 226,
                    labelAlign: 'top'
                },
                width: 'auto',
                items: [{
                    xtype: 'textfield',
                    name: 'equivalentCourseName',
                    itemId: 'equivalentCourseNameId',
                    readOnly: true,
                    fieldLabel: getCommonTranslation('EQUIVALENT_COURSE_NAME'),
                    //		    translationKey:'EQUIVALENT_COURSE_NAME',
                    allowBlank: false
                }, {
                    xtype: 'fieldcontainer',
                    fieldLabel: getCommonTranslation('IS_ACTIVE'),
                    itemId: 'whetherActive',
                    defaultType: 'radiofield',
                    defaults: {
                        flex: 1
                    },
                    layout: 'hbox',
                    items: [{
                        boxLabel: getCommonTranslation('YES'),
                        name: 'whetherActive',
                        inputValue: true,
                        checked: true
                    }, {
                        boxLabel: getCommonTranslation('NO'),
                        name: 'whetherActive',
                        inputValue: false
                    }]
                }, ]
            },

            {
                xtype: 'fieldcontainer',
                width: 'auto',
                layout: {
                    type: 'hbox'
                },
                defaults: {
                    labelAlign: 'top',
                    width: 226
                },
                items: [{
                    xtype: 'checkbox',
                    name: 'enableRepeat',
                    boxLabel: getProgramandcourseTranslation('ENABLE_REPEAT'),
                    itemId: 'enableRepeat',
                    checked: true,
                    inputValue: true,
					hidden:true,
                    uncheckedValue: false
                }, {
                    xtype: 'checkbox',
                    name: 'enableBacklog',
                    boxLabel: getProgramandcourseTranslation('ENABLE_BACKLOG'),
                    itemId: 'enableBacklog',
                    inputValue: true,
					hidden:true,
                    uncheckedValue: false
                }]
            },


            {

                xtype: 'fieldcontainer',
                layout: 'hbox',
                style: {
                    marginLeft: '-03px'
                },
                items: [{
                    xtype: 'button',
                    text: getCommonTranslation('SAVE'),
                    itemId: 'courseEquivalentSaveBtnId',
                    ui: 'CustomBtnSubmit',
                    scale: CONSTANTS.BUTTONSIZE,
                    formBind: true
                }, {
                    xtype: 'button',
                    text: getCommonTranslation('CANCEL'),
                    itemId: 'courseEquivalentCancelBtnId',
                    ui: 'CustomBtnCancel',
                    scale: CONSTANTS.BUTTONSIZE
                }]

            }
        ]
    }]
});