/**
 * @author seshagiri.k
 */
Ext.define('Academia.view.course.coursegroup.CourseGroupAssociatedGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.coursegroupassociatedgrid',
    id:'coursegroupassociatedgrid',
    store: 'course.coursegroup.CourseGroupAssociatedGridStore',
    title: getProgramandcourseTranslation('COURSE_GROUP_ASSOCIATED'),
    border: true,
    viewConfig: {
        stripeRows: true
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins:['pagesize'],
            store: 'course.coursegroup.CourseGroupAssociatedGridStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
    tbar: [],
    columns: [{
        header: getCommonTranslation('COURSE_GROUP_CODE'),
        dataIndex: 'code',
        sortable: true,
        flex: .2
    },{
        header: getCommonTranslation('COURSE_GROUP_NAME'),
        dataIndex: 'courseGroupName',
        sortable: true,
        flex: .2
    }, {
        header: getCommonTranslation('COURSE_NAME'),
        dataIndex: 'courseName',
        sortable: true,
        flex: .2
    }, {
        header: getCommonTranslation('WHETHER_OPTIONAL'),
        dataIndex: 'whetherOptional',
        sortable: true,
        flex: .2,
        renderer:function(value){
			if(value){
				return  'Mandatory';
			}else{
				return 'Optional';
			}
		}
    }, {
        header: getCommonTranslation('NO_OF_PROGRAMS_ASSOCIATED'),
        dataIndex: 'programAssociated',
        sortable:true,
        flex: .2,
        renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
    }]

});