/**
 * @author Raj Kumar
 * @author seshagiri.k
 */
Ext.define('Academia.view.course.coursespecialization.CourseSpecializationGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.coursespecializationgrid',
	store : 'course.coursespecialization.CourseSpecializationStore',
	border : true,
	autoScroll: true,
    viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
            plugins:['pagesize'],
            emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			store : 'course.coursespecialization.CourseSpecializationStore',
			displayInfo : true
		} ]
	} ],
	
	 tbar: [{
	    	xtype : 'button',
			itemId : 'btnAdd',
			tooltip : getCommonTranslation('ADD'),
			glyph : ICONGLYPH.ADDGLYPH
	      },{
			xtype : 'button',				
			itemId : 'btnEdit',
			tooltip : getCommonTranslation('EDIT'),
			glyph: ICONGLYPH.EDITGLYPH
	      }, {
	          xtype: 'button',
	          itemId: 'btnView',
	          tooltip: getCommonTranslation('VIEW'),
	          iconCls: 'view-icon'
	      },{
			xtype : 'button',				
			itemId : 'btnDelete',
			cls: 'CustomToolbarBtnReject',
			tooltip :getCommonTranslation('DELETE'),
			glyph: ICONGLYPH.DELETEGLYPH
	      }/*,{
	          xtype: 'button',
	          itemId: 'btnViewHistory',
	          tooltip: getCommonTranslation('VIEW_HISTORY'),
	          iconCls: 'view-icon'
	      }*/],

	columns : [{
		  hidden : true,
		  dataIndex :'id'
	},{
		header : getCommonTranslation('SPECIALIZATION_CODE'),
		dataIndex : 'specializationCode',
		flex :1
	}, {
		header : getCommonTranslation('SPECIALIZATION'),
		dataIndex : 'specializationName',
		flex : 1
	}, {
		header : getCommonTranslation('NO_OF_ASSOCIATED_COURSE'),
		dataIndex : 'noOfAssociatedCourseGroup',
		flex : 1
	}, {
		header : getCommonTranslation('NO_OF_ASSOCIATED_PROGRAMS'),
		dataIndex : 'noOfAssociatdPrograms',
		flex : 1
	} ]
});
