/**
 * @author sumit.meena
 */
Ext.define('Academia.view.course.readingmaterial.ReadinMaterialFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.readinmaterialfilter',
	autoScroll: false,   
	frame: false,
	cls:'customSearchPanel',
	plugins : "formlabelrequired",
	items : [{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		itemId:'materialTypeRadioFieldId',
		name:'materialTypeRadioFieldId',
		defaults: {
			labelAlign:'top'
		},
		items:[{		 
			xtype: 'radiogroup',
			itemId:'sectionTypeId',
			name:'sectionTypeRadio',
			layout: 'hbox',
			columns: 2,
			vertical: false,
			items:[
				{ boxLabel: getProgramandcourseTranslation('PC_READING_MATERIAL'), name: 'readingMaterial', inputValue: 'READING_MATERIAL',checked:true},
				{ boxLabel: getProgramandcourseTranslation('PC_OTHER_RESOURCES'), name: 'otherResources', inputValue: 'OTHER_RESOURCES', disabled:true}
				]
		}]	 
	},{
		xtype : 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 450,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'multiselectcombofield',
			width: 460,
			name: 'multiselectAcademyLocation',
			cls: 'multiselectAcademyLocation',
			itemId: 'multiselectAcademyLocationId',
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:Ext.create('Academia.store.common.AcademyLocationNameSeparated'),
			displayField:'value',
			valueField:'id',
			matchFieldWidth:true,
			queryMode:'local',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}

		},{
			xtype : 'customcombobox',
			width: 226,
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
			name : 'academicTerm',
			itemId : 'academicTerm',
			displayField : 'value',
			store:Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
			valueField : 'id',
			typeAhead : true,
			editable : false
		}]

	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items: [{
			xtype: 'customcombobox',
			name: 'department',
			itemId:'courseDepartment',
			fieldLabel: getCommonTranslation('COURSE_DEPARTMENT'),			
			store:Ext.create('Academia.store.course.DepartmentByALCourseStore'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:false,
			forceSelection:true,
			queryParam:'qry',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),

			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'+ 
					'</div>';
				}
			}

		},{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
			itemId: 'courseId',
			name: 'COURSE', 
			store:Ext.create('Academia.store.course.AccessibleChildCourseStore'),
			valueField:'id',
			displayField:'valueCode',
			typeAhead:false,
			forceSelection:true,
			queryParam:'courseName',
			minChars:3,
			width:460,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'  +
					'</div>';
				}
			}
		}]
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items: [{
			xtype: 'customcombobox',
			fieldLabel: getProgramandcourseTranslation('PC_COURSE_RESOURCE_TYPE'),
			itemId: 'resourceTypeId',
			name: 'resourceType',
			store:Ext.create('Academia.store.course.readingmaterial.ReadingTypeStore'),
			valueField:'id',
			displayField:'value',
			allowBlank:true,
			typeAhead:false,
			forceSelection:true,
			queryParam:'name',
			minChars:3,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'  +
					'</div>';
				}
			}

		},{ 
			xtype: 'customcombobox',
			name: 'readingName',
			itemId:'readingNameId',
			store:Ext.create('Academia.store.course.readingmaterial.ReadingNameStore'),
			fieldLabel: getCourseTxCommonTranslation('READING_NAME'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'inventoryItemName',
			minChars:3,
			typeAhead:false,
			disabled:false,
			width:460,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		}]
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items: [{
			xtype: 'multiselectcombofield',
			//width: 460,
			name: 'multiselectFirstAuthor',
			cls: 'ProgramCourseMultiselectField',
			itemId: 'multiselectFirstAuthor',
			queryParam:'firstAuthor',
			fieldLabel : getProgramandcourseTranslation('PC_FIRST_AUTHOR'),
			store:Ext.create('Academia.store.course.readingmaterial.FirstAuthorStore'),
			displayField:'code',
			valueField:'id',
			matchFieldWidth:true,
			//queryMode:'local',
			typeAhead : true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			triggerAction: 'all',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}

		},{ 
			xtype: 'multiselectcombofield',
			name: 'isbnTen',
			itemId:'isbnTenId',
			store:Ext.create('Academia.store.course.readingmaterial.ISBNTenStore'),
			fieldLabel: getProgramandcourseTranslation('PC_ISBN_10'),
			valueField: 'id',
			displayField: 'code',
			queryParam:'isbnTen',
			minChars:3,
			typeAhead:true,
			cls: 'ProgramCourseMultiselectField',
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		},{ 
			xtype: 'multiselectcombofield',
			name: 'isbnThirteenth',
			itemId:'isbnThirteenthId',
			store:Ext.create('Academia.store.course.readingmaterial.ISBNThirteenthStore'),
			fieldLabel: getProgramandcourseTranslation('PC_ISBN_13'),
			valueField: 'id',
			displayField: 'code',
			queryParam:'isbnThirteenth',
			minChars:3,
			typeAhead:true,
			//width:460,
			cls: 'ProgramCourseMultiselectField',
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldset',
		collapsible : true,
		collapsed: true,
		title: getCommonTranslation('MORE_FILTERS'),
		titleCollapse: true,
		itemId : 'moreDetailId',
		defaults : {
			labelAlign:'top',
		},
		style: {
			marginTop: '33px!important'
		},
		items:[{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				name : 'programId',
				itemId : 'programId',
				store:Ext.create('Academia.store.course.readingmaterial.ProgramCoursePeriodStore'),
				displayField:'valueCode',
				valueField:'id',
				width:226,
				typeAhead:true,
				forceSelection:true,
				minChars:3,
				queryParam:'programName',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'batchId',
				itemId:'batchId',
				fieldLabel : getCourseTxCommonTranslation('BATCH'),
				disabled:true,
				store: Ext.create('Academia.store.course.readingmaterial.ProgramCoursePeriodStore'),
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true,
				editable : false
			},{
				xtype: 'customcombobox',
				name: 'periodId',
				itemId:'periodId',
				fieldLabel: getExaminationTranslation('PERIOD'),
				store:Ext.create('Academia.store.course.readingmaterial.ProgramCoursePeriodStore'),
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				typeAhead:true,
				editable : false
			}]
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});