/**
 * @author Anshu
 */
Ext.define('Academia.view.course.reports.CourseCreditGradeReportSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.coursecreditgradereportsearchform',
    autoScroll: false,
    frame: false,
	cls:'customSearchPanel',
    style:{
    	marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
    },
    layout: 'vbox',
    items: [{
    	plugins : "formlabelrequired",
         xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
            	width:460,
            	xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
                name: 'academyLocationId',
                itemId: 'academyLocationId',
                store:'common.AcademyLocationNameSeparated',
                displayField: 'value',
                valueField: 'id',
                minChars:3,
                queryParam:'qry',
                typeAhead : true,
				forceSelection : true,
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				}
    			}
            },{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),	
				name : 'academicTerm',
				itemId : 'academicTerm',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				hidden: false,
				store: Ext.create('Academia.store.common.AcademicTermByMappedPeriodStore'),
				editable:false
			}]
	},{
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: {
            type: 'hbox'
        },
        defaults: {
            labelAlign: 'top',
            width:226
        },
        items: [{
    			xtype: 'customcombobox',
    			name: 'department',
    			itemId:'courseDepartment',
    			fieldLabel: getCommonTranslation('COURSE_DEPARTMENT'),
    			store:'course.CourseDepartmentALWiseStore',
    			editable: true,
    			valueField: 'id',
    			displayField: 'value',
    			typeAhead : true,
				forceSelection : true
    		},{
    			xtype: 'customcombobox',
                name: 'programCategory',
                itemId : 'programCategory',
                fieldLabel: getProgramandcourseTranslation('PROGRAM_CATEGORY'),
                store:'program.MappedProgramCategorybyAlStore',
                displayField:'value',
                valueField:'id',
                typeAhead : true,
				forceSelection : true,
            
            },{
    			xtype: 'customcombobox',
    			width:226,
    			name:'programNameOrCode',
    			store: Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodDetailStore'),
    			itemId:'programId',
    			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
    			valueField: 'code',
    			displayField: 'valueCode',
    			queryParam:'name',
    			minChars:3,
    			typeAhead : true,
				forceSelection : true,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
               	listConfig: {
    				  listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    	                loadingText: getCommonTranslation('SEARCHING'),
    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    	                getInnerTpl: function() {
    	                    return '<div class="search-item">' +
    	                        '{code} / {value}'+ 
    	                    '</div>';
    	                }
    	            }
    		
            },{
				xtype: 'customcombobox',
	    	   	itemId: 'programIds',
	    	   	name:'programId',
    			store: 'program.ProgramByALAcademicTermAndCategoryStore',
	    	     hidden:true
			}]
	},{
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: {
            type: 'hbox'
        },
        defaults: {
            labelAlign: 'top',
            width:226
        },
        items: [{
				xtype: 'customcombobox',
				name: 'batch',
				itemId : 'batchId',
				fieldLabel: getCommonTranslation('BATCH'),
				store: Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodDetailStore'),
	        	displayField : 'value',
	        	valueField : 'id',
				disabled : true,
				typeAhead : true,
				forceSelection : true,
			},{
				xtype: 'customcombobox',
				name: 'period',
				itemId : 'periodId',
				fieldLabel: getCommonTranslation('PERIOD'),
				store : Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodDetailStore'),
	        	displayField : 'value',
	        	valueField : 'id',
				disabled : true,
				typeAhead : true,
				forceSelection : true,
			},{
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
                name: 'courseId',
                itemId: 'courseId',
                disabled:false,
                editable: true,
                typeAhead : true,
				forceSelection : true,
				hideTrigger:true,				
				store: 'course.CourseComboByCriteriaStore',
                queryParam:'courseName',
            	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                displayField: 'value',
                valueField: 'id',
                minChars:3,
                width: 226,
                enableKeyEvents  : 'true',
				hideTrigger:false,
                listConfig: {
  				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{code} / {value}'+ 
	                    '</div>';
	                }
	            } 
            }]   
        },{	
    		xtype:'fieldcontainer',
    		width: '100%',
    		 
    		items:[{  
   			 xtype: 'button',
             text: getCommonTranslation('SEARCH'),
             itemId: 'courseReportSearchButtonId',
             buttonAlign: 'left',
             ui: 'CustomBtnSubmit',
             scale: CONSTANTS.BUTTONSIZE,
             formBind : true
	     },{
    			xtype: 'button',
    			itemId: 'resetBtn',
    			text: getCourseTxCommonTranslation('RESET'),
    			ui:'CustomBtnCancel',
    			scale: CONSTANTS.BUTTONSIZE
    		}]	
        }]
    });