/**
 * @author Vishal Joshi
 */
Ext.define('Academia.view.coursesessiondiary.CourseSessionDiaryFacultyPortalGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.coursesessiondiaryfacultyportalgrid',
	store: 'coursesessiondiary.CourseSessionDiaryGridStore',
	title: getCommonTranslation('COURSE_SESSION_DAIRY'),
//	translationKey :'COURSE_SESSION_DAIRY',
	border: true,
	autoScroll: false,
	frame:false,
//	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'coursesessiondiary.CourseSessionDiaryGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {

		var grid=this;                   

		grid.addExportToolBarItems(grid);

		this.callParent(arguments);     

	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation("ADD"),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation("EDIT"),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation("VIEW"),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation("DELETE"),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [/*{
		header:  getExaminationTranslation('ID'),
		dataIndex: 'id',
		flex:.1,
		hidden:true,
		sortable:true
	},*/{
		header: getCommonTranslation("DATE"),
		dataIndex: 'date',
		flex:.1,
		sortable:true,
		renderer : function(date){
			return dateRender(date);
		}
	},{
		header:  getProgramandcourseTranslation('SESSION_NO'),
		dataIndex: 'sessionNumber',
		flex:.1
	},{
		header: getProgramandcourseTranslation('COURSE'),
		dataIndex: 'course',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("COMPONENT"),
		dataIndex: 'component',
		flex:.1,
		sortable:true
	},{
		header:  getProgramandcourseTranslation('COURSE_VARIANT'),
		dataIndex: 'courseVariant',
		flex:.1,
		sortable:true
	},/*{
		header:  getProgramandcourseTranslation('FACULTY'),
		dataIndex: 'facultyName',
		flex:.1,
		sortable:true
	},*/{
		header:  getCommonTranslation("TOPIC"),
		dataIndex: 'topic',
		flex:.1,
		sortable:true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(isNullOrEmpty(val)){
	    		return "";
	    	} else {
	    		
	    		rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
	    		rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 6;-webkit-box-orient: vertical;line-height: 15px;max-height: 103px;min-width: 16ch;max-width: 17ch;';
	    		return val;
	    		
	    		
				/*rec.tdAttr = 'data-qtip="' + val + '"';
	    		rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 1;-webkit-box-orient: vertical;line-height: 15px;max-height: 30px;max-width: 17ch;';
	    		return val;*/
    		}
		}
	},{
		header:  getCommonTranslation('DESCRIPTION'),
		dataIndex: 'description',
		flex:.1,
		sortable:true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(!isNullOrEmpty(val)){
				return	"<a href='#'>View</a>"; 
			}else{
				return "";
			}
		}
	},{
		header:  getCommonTranslation("PUBLISH_TO_STUDENT"),
		dataIndex: 'publishToStudent',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(record.data.publishToStudent){
				return "<span style=\'color:green\'>Yes</span>";
			} else {
				return "<span style=\'color:red\'>No</span>";
			}
		}                        
	},{
		header: getCommonTranslation("PUBLISH_TO_PARENT"),
		dataIndex: 'publishToParent',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(record.data.publishToParent){
				return "<span style=\'color:green\'>Yes</span>";
			} else {
				return "<span style=\'color:red\'>No</span>";
			}                   
		}
	},{
		header:  getCommonTranslation("DOCUMENTS"),
		dataIndex: 'document',
		sortable:true,
		//hidden:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.documents)) {
				if(record.data.documents.length>1) {					
					return '<a href=#>'+record.data.documents.length+'<a>';
				} else if(record.data.documents.length==1) {
					return '<a href=#>'+record.data.documents[0].value+'<a>';
				} 
			}                        
		}
	
//		renderer : function(value){
//			return value.value;
//		}
	},{
		header:  getCommonTranslation("FROM_DATE"),
		dataIndex: 'fromDate',
		flex:.1,
		sortable:true,
		hidden:true,
		renderer : function(date){
			return dateRender(date);
		}
	},{
		header:  getCommonTranslation("TO_DATE"),
		dataIndex: 'toDate',
		flex:.1,
		sortable:true,
		hidden:true,
		renderer:function(value, record){
        	return dateRender(value);
        }
	}]
});

