Ext.define('Academia.view.coursetransaction.coursereading.CourseReadingList', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.coursereadinglist',
	store : 'coursetransaction.coursereading.CourseReadingListGrid',
	//title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
	title: getCommonTranslation('LIST_OF_COURSE_READING_MATERIAL'),
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	cls: 'promotionlistGridCls',
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
		      xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
			store : 'coursetransaction.coursereading.CourseReadingListGrid',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
	tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    },
    {
	    xtype : 'splitbutton',
	    itemId:'spBtnMoreActions',
	    text : getCommonTranslation('MOREACTIONS'),
	    menu:[{
		text:getCourseTxCommonTranslation('ASSIGN_COURSE_VARIANT'),
		itemId:'textLinked'
	    }],
	    listeners: { click: function() { this.showMenu(); } }
	}],
	columns : [/*{
		hidden:true,
		dataIndex:'id'
	},*/{
		header :getCourseTxCommonTranslation('COURSE_NAME'),
		dataIndex : 'courseName',
		flex:1
	},{
		header : getCourseTxCommonTranslation('GENERAL_SPECIFIC'),
		dataIndex : 'topicType',
		flex:1
	},{
		header : getCourseTxCommonTranslation('TOPIC_NO'),
		dataIndex : 'noOfCount',
		flex:1,
		renderer: function (value) {
			if(value>0){
		    return '<a href="#">'+value+'</a>';
			}else{
				return "0";
			}
		}
	},{
		header : getCourseTxCommonTranslation('DISTRIBUTION_MODE'),
		dataIndex : 'modeName',
		flex:1
	},{
		header : getCourseTxCommonTranslation('READING_TYPE'),
		dataIndex : 'readingTypeName',
		flex:1
	},{
		header : getCourseTxCommonTranslation('READING_TITLE'),
		dataIndex : 'readingName',
		flex:1,
		renderer: function(value,meta,record) {
			if(record.data.readingTypeName == 'Link'){
				return '<a href='+value+' target=_blank>'+value+'</a>'
			} if(record.data.readingTypeName == 'Youtube'){
				 return '<a href="#">'+value+'</a>';
			} else {
				return value
			}
		}
	},{
		header : getCourseTxCommonTranslation('DOCS_NO'),
		dataIndex : 'noOfDocs',
		flex:1,
		renderer: function (value) {
			if(value>0){
		    return '<a href="#">'+value+'</a>';
			}else{
				return "0";
			}
		}
	},{
		header : getCourseTxCommonTranslation('ASSIGNMENT_NAME'),
		dataIndex : 'assignmentName',
		flex:1
	},{
		header : getCourseTxCommonTranslation('COMPULSORY_OPTIONAL'),
		dataIndex : 'whetherCompulsory',
		flex:1.10,
		renderer : function(value) {
			if (value) {
			    return value = getCourseTxCommonTranslation('COMPULSORY');
			} else {
			    return value = getCourseTxCommonTranslation('OPTIONAL');
			}
		    }
	}]
});
