/**
 * @author Rajkumar.Patidar
 */
Ext.define('Academia.view.coursetransaction.homework.HwTopicWise', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.hwtopicwise',
	plugins : "formlabelrequired",
	//title : getCommonTranslation('QUICK_SEARCH'),
    frame: false,
    layout: 'vbox',
    method: 'POST',
    standardSubmit: false,
    items: [{
       	xtype: 'fieldcontainer',
       	width:'100%',
		layout: {
			type: 'hbox'
		},
		defaults :{
			labelAlign:'top',
			width:223
		},
		items:[{
			xtype: 'customcombobox',
			name:'facultyName',
			itemId:'facultyName_Id_topicWise',
			store: Ext.create('Academia.store.attendance.FacultyCodeSmartSearch'),
			fieldLabel :getCommonTranslation('FACULTY_CODE'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'codeOrName',
			minChars:3,
			hidden:false,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			hidden: true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}
		]
        },{
           	xtype: 'fieldcontainer',
           	width:'100%',
    		layout: {
    			type: 'hbox'
    		},
    		defaults :{
    			labelAlign:'top',
    			width:223
    		},
    		items:[{
				 xtype: 'customcombobox',
			     name: 'assignmentType',
			     itemId:'assignmentType_Id',
			     fieldLabel: getCourseTxCommonTranslation('HW_ASSIGNMENT_TYPE'),
			     store:'coursetransaction.homework.HW_AssignmentTypeDropDown',
			     displayField:'value',
			     valueField:'id',
			     forceSelection:true,
			     typeAhead:true
    		},{
    			xtype: 'customcombobox',
    			name: 'assignmentName',
    			///itemId:'assignFaculty_1_ItemId',
    			fieldLabel: getCourseTxCommonTranslation('HW_ASSIGNMENT_NAME'),
    			store:'coursetransaction.homework.AssignmentNameDropDown',
    			displayField:'value',
    			valueField:'id',
    			forceSelection:true,
    			//queryMode: 'local',
    			typeAhead:true
    		},{
    			xtype:'combo',
    			name: 'assessmentType',
    			itemId:'assessmentTypeItemId_topicWise',
    			fieldLabel : getExaminationTranslation('EVALUATION_TYPE'),
    			valueField: 'id',
    			displayField: 'id',
    			typeAhead:true,
    			forceSelection:true,
    			hidden: true,
    			queryMode:'local',
    			store:['All','Random Code Assessment','Regular Assessment']
    		}]
            },{
               	xtype: 'fieldcontainer',
               	width:'100%',
        		layout: {
        			type: 'hbox'
        		},
        		defaults :{
        			labelAlign:'top',
        			width:223
        		},
        		items:[  {
          			 xtype: 'datefield',
        		     name: 'fromDate',
        		     itemId:'fromDate',
        		     fieldLabel: getCourseTxCommonTranslation('HW_FROM_DATE'),
        		   //--submitFormat : CONSTANTS.DATE_FORMAT,
       	        	 endDateField : 'toDate',
       	        	 vtype : 'daterange',
    				listeners: {
    					render: function(field) {
    						return dateFormatRender(field);
    					}
    				}
        		     
        			},{
           			 xtype: 'datefield',
        		     name: 'toDate',
        		     itemId:'toDate',
        		     fieldLabel: getCourseTxCommonTranslation('HW_TO_DATE'),
        		   //--submitFormat : CONSTANTS.DATE_FORMAT,
       	        	 startDateField : 'fromDate',
       	        	 vtype : 'daterange',
    				listeners: {
    					render: function(field) {
    						return dateFormatRender(field);
    					}
    				}
        		    }]
                }]
});
