
Ext.define('Academia.view.coursetransaction.homework.assignmentDetails.AssignDetailsGroupGrid', {
    extend : 'Ext.grid.Panel',
    alias : 'widget.assigndetailsgroupgrid',
    store : 'coursetransaction.homework.assignmentdetails.AssignmentGroupBlank',
    refreshStoreData:true,
    border: true,
	selType:'checkboxmodel',
    viewConfig : {
    	stripeRows : CONSTANTS.STRIPEROWS
    },
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
    tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype: 'button',
		itemId: 'uploadDocument',
		text : getCommonTranslation('UPLOAD_DOCUMENT')		
	}],
    columns : [{
		 xtype: 'rownumberer',
		 header: getCommonTranslation('SNO'),
		 align :'left',
		 flex:.5
	 }, {
	    header : getCourseTxCommonTranslation('HW_GROUP_NAME'),
	    dataIndex : 'groupName',
	    flex:1,
	    sortable : true
	}, {
	    header : getCommonTranslation('STUDENT_ID'),
	    dataIndex : 'studentCode',
	    flex:1
	   
	},{
	    header : getCourseTxCommonTranslation('HW_ADMISSION_ID'),
	    dataIndex : 'admissionCode',
	    flex:1
	   
	}, {
	    header : getCourseTxCommonTranslation('HW_STUDENT_NAME'),
	    dataIndex : 'studentName',
	    flex:1,
	    sortable : true
	}, {
		header : getCommonTranslation('FIRST_NAME'),
		dataIndex : 'firstName',
		flex : 1,
		hidden :true
	}, {
		header : getCommonTranslation('MIDDLE_NAME'),
		dataIndex : 'middleName',
		flex : 1,
		hidden :true
	}, {
		header : getCommonTranslation('LAST_NAME'),
		dataIndex : 'lastName',
		flex : 1,
		hidden :true
	}, {
	    header : getCourseTxCommonTranslation('HW_PROGRAM'),
	    dataIndex : 'programName',
	    flex:1,
	    sortable : true,
	    hidden:true
	}, {
	    header : getCourseTxCommonTranslation('HW_BATCH'),
	    dataIndex : 'batchName',
	    flex:1,
	    sortable : true,
	    hidden:true
	}, {
	    header : getCourseTxCommonTranslation('HW_PERIOD'),
	    dataIndex : 'periodName',
	    flex:1,
	    sortable : true,
	    hidden:true
	}, {
		header : getProgramandcourseTranslation('DEENROLLED_AFTER_ENROLLMENT'),
		dataIndex : 'isWithDrawn',
		flex:1,
		sortable : true,
		hidden:true,
		renderer: function (value,rec) {
			if(rec.record.data.isWithDrawn){
				return 'No';
			}else{
				return 'Yes';
			}
		}
	}, {
	    header : getCourseTxCommonTranslation('HW_GROUP_LEADER'),
	    dataIndex : 'whetherGroupLeader',
	    flex:1,
	    renderer:function(value,meta,record){
	    	if(!isNullOrEmpty(record.data.groupLeaderName)) {				// for student portal
	    		if(record.data.groupLeaderName == record.data.groupLeader) {
	    			return getCommonTranslation('YES');	    			
	    		}else{
	    			return record.data.groupLeaderName;	    			
	    		}
	    	}else{
	    		if(record.data.groupLeader || record.data.groupLeader == 'true'){
	    			return getCommonTranslation('YES');
	    		}else{
	    			return getCommonTranslation('NO');
	    		}	    		
	    	}
	    } 
	   
	}, {
	    header : getCourseTxCommonTranslation('HW_FILE_NAME'),
	    dataIndex : 'documentName',
	    flex:1,
	    sortable : true,
	    renderer: function (value,rec) {
	    	if(!isNullOrEmpty(rec.record.data.documentId)){
	    		return '<a href="#">'+value+'</a>';
	    	}else{
	    		return value;
	    	}
	    }
	}]
});
