Ext.define('Academia.view.coursetransaction.managedistribution.ManageDistributionList', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.managedistributionlist',
	store : 'coursetransaction.managedistributionlist.ManageDistributionList',
	title: getCommonTranslation('LIST_OF_COURSE_READING_MATERIAL'),
	border: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
		      xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
			store : 'coursetransaction.managedistributionlist.ManageDistributionList',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
	tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    },/* {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    },*/ {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }],
	columns : [/*{
		hidden:true,
		dataIndex:'id'
	},*/{
		header :getCourseTxCommonTranslation('LIST_NAME'),
		dataIndex : 'listName',
		flex:1,
		renderer: function (value) {
			if (!isNullOrEmpty(value)) {
			    return '<a href="#">'+value+'</a>';
				}
		}
	},{
		header : getCourseTxCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex:1
	},{
		header : getCourseTxCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex:1
	},{
		header : getCourseTxCommonTranslation('PERIOD'),
		dataIndex : 'periodName',
		flex:1
	},{
		header : getCourseTxCommonTranslation('SECTION'),
		dataIndex : 'sectionName',
		flex:1
	},{
		header : getProgramandcourseTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocationName',
		flex:1
	}
	]
});
