/**
 * @author Ashwin Rawal
 */
Ext.define('Academia.view.coursetransaction.manageperiodenrollment.downloadPeriodEnrollmentform',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.downloadperiodenrollmentform',
	autoScroll: false,
	frame: false,
	standardSubmit: false,
	items: [{
		xtype : 'fieldcontainer',
		items : [{
			xtype: 'fieldcontainer',
            width: '100%',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top'
            },
            items: [{
                xtype: 'customcombobox',
                name: 'academyLocation',
                itemId: 'academyLocationId',
                fieldLabel: getProgramandcourseTranslation('ACADEMY_LOCATION'),
                width: 226,
                valueField: 'id',
                displayField: 'value',
                store:Ext.create('Academia.store.coursetransaction.sectionmanagement.AcademyLocationsByUserStore'),
    			valueField : 'id',
    			displayField : 'value',
    			minChars:3,
    			hideTrigger:false,
    			triggerAction: 'all',
    			queryParam:'name',
    			allowBlank:false,
    			typeAhead : true,
    				editable : true,
    				queryMode:'local',
                 	forceSelection : true,
                 	anyMatch : true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
            },{
                xtype: 'customcombobox',
                name: 'academicTerm',
                itemId: 'academicTermId',
                fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
                width: 226,
                editable: false,
                queryMode: 'local',
                displayField: 'value',
                valueField: 'id',
            //    store:'enquiry.AcademicBatchStore',
                store : Ext.create('Academia.store.common.findAcademicTermForRegistrationCheckTrue'),
                allowBlank: false,
            },{
				xtype: 'multiselectcombofield',
				name: 'programId',
				itemId: 'programId',
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				valueField: 'id',
				displayField: 'valueCode',
				store : 'common.ProgramForRegistrationProcessStore',
				width:226,
				height: 30,
				disabled:true,
				queryParam:'programName',
				maxLength:500000,
				typeAhead : true,
				allowBlank:false,
				forceSelection:true,
				hideTrigger:false,
				triggerAction: 'all',
				autoloadStore: false,
				minChars:3,
				cls:'ProgramCourseMultiselectField',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
	    			listeners: {
	    				beforeshow: function(picker) {
	    					picker.minWidth = picker.up('combobox').getSize().width;
	    				}
	    			},
	    			loadingText: getCommonTranslation('SEARCHING'),
	    			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	    			getInnerTpl: function() {
	    				return '<div class="search-item">' +
	    				'{code} / {value}'+ 
	    				'</div>';
	    			}
	    		}
			},{
				xtype: 'multiselectcombofield',
				name: 'batchId',
				itemId: 'batchId',
				fieldLabel: getPersonModuleTranslation('BATCH'),
				store:'lecturercostingdefinition.ImportPeriodEnrollmentBatchStore',
				disabled:true,
				width: 300,
				height: 30,
				displayField: 'valueCode',
				valueField: 'id',
				queryParam:'name',
				typeAhead : true,
				allowBlank:false,
				//forceSelection:true,
				//hideTrigger:false,
				//triggerAction: 'all',
				//autoloadStore: false,
				minChars:3,
				maxLength:500000,
				cls:'ProgramCourseMultiselectField',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			}]
        },{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width: '100%',
			defaults: {
				labelAlign: 'top'
			},
			items :[{
				xtype: 'multiselectcombofield',
				name: 'periodId',
				itemId:'periodId',
				fieldLabel: getCourseTxCommonTranslation('PERIOD'),
				store: Ext.create('Academia.store.lecturercostingdefinition.ImportPeriodEnrollmentPeriodStore'),
				valueField: 'id',
				displayField: 'value',
				typeAhead : true,
				forceSelection:true,
				hideTrigger:false,
				triggerAction: 'all',
				minChars:3,
				disabled:true,
				width:460,
				queryParam:'name',
				autoloadStore:false,
				maxLength:500000,
				cls:'ProgramCourseMultiselectField',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}'  +
						'</div>';
					}
				}
			},{
				xtype : 'multiselectcombofield',
				fieldLabel : getCourseTxCommonTranslation('SECTION'),
				labelAlign : 'top',
				name : 'sectionId',
				itemId : 'sectionId',
				disabled : true,
				store: Ext.create('Academia.store.lecturercostingdefinition.ImportPeriodEnrollmentSectionStore'),
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				forceSelection:true,
				hideTrigger:false,
				triggerAction: 'all',
				minChars:3,
				disabled:true,
				width:460,
				queryParam:'name',
				autoloadStore:false,
				maxLength:500000,
				cls:'ProgramCourseMultiselectField',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}'  +
						'</div>';
					}
				}
			},
			{
				xtype : 'multiselectcombofield',
				fieldLabel : getCommonTranslation('PERIOD_ENROLLMENT_STATUS'),
				name : 'statusId',
				itemId : 'statusId',
				width: 226,
				height: 30,
				store : 'coursetransaction.manageperiodenrollment.PeriodEnrollStatusStoreForImport',
				labelAlign : 'top',
				displayField : 'value',
				valueField : 'id',
				allowBlank:false,
				forceSelection : false
			}
		]
		},{
			xtype: 'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults : {
				labelAlign : 'top'
			},
			items: [{
	           	 xtype: 'button',
	        	 text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
	             itemId: 'downoladBtnId',
	             formBind : true,
	             ui: 'CustomBtnSubmit'
	        },{
                xtype: 'button',
                text: getCourseTxCommonTranslation('RESET'),
                itemId: 'resetBtn',
                buttonAlign: 'left',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
		}]
	}]});
