/**
 * Amit G
 */
Ext.define('Academia.view.coursetransaction.sectioncoursecoverageplan.SessionCancellationWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.sessioncancellationwindow',
	modal: true,
	autoScroll:true,
	title: '<span style="font-size:14px">'+getCommonTranslation('SESSION_CANCELLATION')+'</span>',
	maxHeight:500,
	width: '40%',
	items: [{
		xtype: 'form',
		method: 'POST',
		itemId:'substitutesessionwindowId',
		margin: 0,
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			autoScroll:true,
			
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'ids',
			itemId:'ids',
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'textarea',
				name:'reasonForCancellation',
				itemId:'reasonForCancellation',
				width: 450,
				labelStyle: 'font-weight:bold;font-size:14px !important;',
				maxLength : 500,
				fieldLabel: getCommonTranslation('ARE_YOU_SURE_YOU_WANT_TO_CANCEL_THE_SELECTED_SESSIONS_IF_YES_ENTER_REASON_BELOW_IF_NO_SIMPLY_CLICK_CANCEL'),
				allowBlank:false
			}]
		}, {
			xtype: 'fieldcontainer',
			width: '100%',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SAVE'),
				itemId: 'saveBtn',
				buttonAlign: 'right',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			},
			{
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				itemId: 'cancelBtn',
				buttonAlign: 'right',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE,
			}]
		}]
	}]
});