var consolidateSummaryGridStore = Ext.create('Academia.store.coursetransaction.sectionmanagement.CoruseProgramMappingGridStore');
Ext.define('Academia.view.coursetransaction.sectionmanagement.ManageCourseSectionSummaryViewGrid',{ 
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.managecoursesectionsummaryviewgrid',
	store : consolidateSummaryGridStore,
	title: getCommonTranslation('COURSE_SECTION_LIST'),
	border: true,
	refreshStoreData:true,
	selType :'checkboxmodel',
    itemId: 'managecoursesectionsummaryviewgridId',
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'coursesectionmanagementstructure':1
		}
	},
	dockedItems : [ {
		itemId:'dockedItemsItemId',
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : consolidateSummaryGridStore,
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}
	],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);
	},
	tbar: [{
		xtype: 'button',
		text:getCourseTxCommonTranslation('ADD_SECTION'),
		itemId:'addSection',
		tooltip :getCourseTxCommonTranslation('ADD_SECTION'),
		disabled:true
	},{
		xtype: 'button',
		text:getCourseTxCommonTranslation('MAP_PROGRAM_PERIOD'),
		itemId:'mapProgramPeriod',
		tooltip :getCourseTxCommonTranslation('MAP_PROGRAM_PERIOD'),
		disabled:true
	},'->'],
	columns: [{
		header : getCommonTranslation('COURSE_CODE'),
		dataIndex : 'courseCode',
		flex : 1
	},
	{
		header : getCommonTranslation('COURSE_NAME'),
		dataIndex : 'courseName',
		flex : 1
	},
	{
		header : getCommonTranslation('NO_OF_SECTIONS'),
		dataIndex : 'noOfSection',
		flex : 1
	},{
		header : getProgramandcourseTranslation('PROGRAMS_ASSOCIATED'),
		dataIndex : 'programAssociated',
		flex : 1
	}]
});
