/*
 * @author Rajkumar.patidar
 */
Ext.define('Academia.view.coursetransaction.sectionmanagement.ProgramBatchSectionSearch', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.programbatchsectionsearch',
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	method : 'POST',
	standardSubmit : false,
	defaults: {
		labelAlign:'top',
		width:226
	},
	plugins : "formlabelrequired",
	//bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
	items: [{
		xtype:'hidden',
		name:'id'
	},{
		xtype: 'customcombobox',
		name: 'program',
		width:460,
		itemId: 'programId',
		fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
//		translationKey: 'PROGRAM',
		store:'common.ProgramStore',
		displayField:'valueCode',
		valueField:'id',
		allowBlank:false,
		typeAhead : true,
        forceSelection:true,
        hideTrigger:false,
        //queryMode: 'local',	    
	    triggerAction: 'all',
	    //anyMatch : true,
	    queryParam:'programName',
	    minChars:3,
        emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        listConfig: {
			  listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                    '{value}'  +
                    '</div>';
                }
            }
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype: 'customcombobox',
			name: 'batchId',
			fieldLabel: getCourseTxCommonTranslation('BATCH'),
			itemId:'batchId',
			store: 'common.CurrentBatchStore',
			valueField: 'id',
			displayField: 'value',
			allowBlank:false,
			forceSelection:true,
			queryMode:'local',
			typeAhead : false,
			anyMatch : true,
			disabled : true
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId:'periodId',
			fieldLabel: getCourseTxCommonTranslation('PERIOD'),
			store: Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod'),
			valueField: 'id',
			displayField: 'value',
			allowBlank:false,
			forceSelection:true,
			queryMode:'local',
			typeAhead : false,
			anyMatch : true,
			disabled : true 
		}]  

	},{
		xtype:'fieldcontainer',
		width: '100%',
		 
		items:[{  
			xtype: 'button',
			itemId: 'searchBtn',
			formBind:true,
			text: getCourseTxCommonTranslation('SEARCH'),
			ui:'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
	     },{
			 xtype: 'button',
			 itemId: 'resetBtn',
			 text: getCourseTxCommonTranslation('RESET'),
			 ui:'CustomBtnCancel',
			 scale: CONSTANTS.BUTTONSIZE
		}]	
	}]
});