/**
 * @author Akshay Sharma
 */

Ext.define('Academia.view.coursetransaction.studentcourseenrollment.CBSEnrollmentDateChangeWindow',{
	extend: 'Ext.window.Window',
	alias: 'widget.cbsenrollmentdatechangewindow',
	autoScroll: true,
	title:getProgramandcourseTranslation('CHANGE_ENROLLMENT_DATE'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'form',
		bodyPadding: '5 5 5 5',
		margin: 0,
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			width:'auto'
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				labelAlign: 'left'
			},
			items:[{
				xtype:'displayfield',
				name : 'StudentCount',
				fieldLabel: getProgramandcourseTranslation('NO_OF_STUDENT_SELECTED')
			}]
		},{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				labelAlign: 'top',
				width:226
			},
			items:[{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getCommonTranslation('PROGRAM_PERIOD_START'),
				name : 'periodStartDate',
				itemId : 'periodStartDate',
				disabled:true,
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);
					}
				}
			},{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getCommonTranslation('PROGRAM_PERIOD_END'),
				name : 'periodEndDate',
				itemId : 'periodEndDate',
				disabled: true,
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);
					}
				}
			}]
		},{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				labelAlign: 'top',
				width:226
			},
			items:[{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getProgramandcourseTranslation('NEW_DATE_OF_ENROLLMENT'),
				name : 'newEnrollmentDate',
				itemId : 'newEnrollmentDate',
				allowBlank : false,
				//minValue: new Date(),
                maxValue:new Date(),
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
					}
				}
			}]
		},{
			xtype:'displayfield',
			value:'<b class="menu-title">'+getProgramandcourseTranslation('FOR_MISSING_ATTENDANCE_RECORDS_MARK_STUDENT_ATTENANCE_AS')+'</b>',
		},{
			xtype:'fieldcontainer',
			width:'auto',
			defaults: {
				width: 226,
				//labelAlign: 'top'
			},
			items:[{
				xtype:'panel',
				width:'100%',
				cls: 'panelNoSpace',
				items:[{
					xtype: 'radiogroup',
					width:400,
					name: 'attendanceMarkType',
					itemId:'attendanceMarkType_ID',
					defaults: {
						flex: 1
					},
					items:[{ boxLabel: getProgramandcourseTranslation('MARK_ALL_PRESENT'), name: 'attendanceMarkType', inputValue: 'PRESENT', checked : true },
					       { boxLabel: getProgramandcourseTranslation('MARK_ALL_ABSENT'), name: 'attendanceMarkType', inputValue: 'ABSENT'}]
				}]
			}]
		},{	
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				labelAlign: 'top'
			},
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getCourseTxCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'submitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCourseTxCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'cancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]     
});