Ext
		.define(
				'Academia.view.coursetransaction.studentcourseenrollment.StudentCourseEnrollmentGrid',
				{
					extend : 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
					alias : 'widget.studentcourseenrollmentgrid',
					store : 'coursetransaction.studentenrollment.enrollmentmaster.StudentCourseVariantStatusGrid',
					title : getProgramandcourseTranslation('LIST_OF_EROLLED_STUDENTS'),
					selType : 'checkboxmodel',
					itemId : 'studentcourseenrollmentgrid',
					selModel : {
						mode : 'MULTI',
						allowDeselect : false,
						checkOnly : true,
					},
					border : true,
					autoScroll : true,
					viewConfig : {
						stripeRows : CONSTANTS.STRIPEROWS
					},
					initComponent : function() {
						var grid = this;
						grid.addExportToolBarItems(grid);
						this.callParent(arguments);
					},
					dockedItems : [{
						xtype : 'toolbar',
						dock : 'bottom',
						items : [ {
							xtype : 'custompagingtoolbar',
							plugins : [ 'pagesize' ],
							displayInfo : true,
							emptyMsg : getCommonTranslation('NORESULTSNMESSAGE'),
							store : 'coursetransaction.studentenrollment.enrollmentmaster.StudentCourseVariantStatusGrid'
						} ]
					}],
					tbar : [ {
						xtype : 'button',
						itemId : 'btnCourseUnEnrollStudent',
						text : getProgramandcourseTranslation('DE_ENROLL'),
						tooltip : getProgramandcourseTranslation('DE_ENROLL'),
					},{
						 xtype: 'button',
						 itemId: 'btnChangeCourseEnrollemntDate',
						 text: getProgramandcourseTranslation('CHANGE_ENROLLMENT_DATE'),
					 }],
					 columns : [{
						 header : getCommonTranslation('STUDENT_CODE'),
						 dataIndex : 'studentCode',
						 sortable : true,
						 flex : .1
					 }, {
						 header : getCommonTranslation('ADMISSION_CODE'),
						 dataIndex : 'admissionCode',
						 sortable : true,
						 flex : .1
					 }, {
						 header : getCommonTranslation('STUDENT_NAME'),
						 dataIndex : 'studentName',
						 sortable : true,
						 flex : .1
					 },{
						 header : getCommonTranslation('ENROLLMENT_DATE'),
						 dataIndex : 'enrollmentDate',
						 sortable : true,
						 flex : .1,
						 renderer:function(date) {
							 return dateRender(date);
						 }
					 }]
				});