Ext.define('Academia.view.coursetransaction.studentcourseenrollment.studentcourseregistrationrevamp.PBSCourseUnenrollmentGrid',
		{
	extend : 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.pbscourseunenrollmentgrid',
	store : 'coursetransaction.studentenrollment.enrollmentmaster.StudentCourseVariantStatusGrid',
	title : getProgramandcourseTranslation('LIST_OF_UNEROLLED_STUDENTS'),
	selType : 'checkboxmodel',
	selModel : {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	border : true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	initComponent : function() {
		var grid = this;
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins : [ 'pagesize' ],
			displayInfo : true,
			emptyMsg : getCommonTranslation('NORESULTSNMESSAGE'),
			store : 'coursetransaction.studentenrollment.enrollmentmaster.StudentCourseVariantStatusGrid'
		} ]
	} ],
	tbar : [ {
		xtype : 'button',
		itemId : 'btnCourseEnrollStudent',
		text : getProgramandcourseTranslation('ENROLL'),
		tooltip : getProgramandcourseTranslation('ENROLL'),
	}],
	columns : [{
		header : getCommonTranslation('STUDENT_CODE'),
		dataIndex : 'studentCode',
		sortable : true,
		flex : .1,
		renderer:function(value,meta,record){
			if(record.data.studentCode == 0){
				return record.data.studentCode ;
			} else {
				return '<a href=#>'+record.data.studentCode +'</a>'
			}
		}
	}, {
		header : getCommonTranslation('ADMISSION_CODE'),
		dataIndex : 'admissionCode',
		sortable : true,
		flex : .1
	}, {
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		sortable : true,
		flex : .1
	},{
		header : getCommonTranslation('FIRST_NAME'),
		dataIndex : 'firstName',
		flex : .1,
		hidden :true
	},{
		header : getCommonTranslation('MIDDLE_NAME'),
		dataIndex : 'middleName',
		flex : .1,
		hidden :true
	},{
		header : getCommonTranslation('LAST_NAME'),
		dataIndex : 'lastName',
		flex : .1,
		hidden :true
	}]
		});