/*
 * @author sumit meena
 */
Ext.define('Academia.view.coursetransaction.studentcourseenrollment.studentenrollmentdetail.courses.StudentOptionalCourses', {   
	extend : 'Ext.grid.Panel',
	alias : 'widget.studentoptionalcourses',
	store : 'coursetransaction.studentenrollment.studentenrollmentdetail.courses.OptionalCourses',
	border:true,
	//frame: true,
	autoScroll: true,
    /*viewConfig : {
	stripeRows : CONSTANTS.STRIPEROWS
    },*/
	requires:(['Ext.dd.*']),
	height:400,
	multiSelect: true,
    viewConfig: {
        plugins: {
            ptype: 'gridviewdragdrop',
            dragGroup: 'firstGridDDGroup',
            dropGroup: 'secondGridDDGroup'
        },
        listeners: {
            drop: function(node, data, dropRec, dropPosition) {
                var dropOn = dropRec ? ' ' + dropPosition + ' ' + dropRec.get('courseName') : ' on empty view';
                //showWarningMessage("Drag from right to left", 'Dropped ' + data.records[0].data.courseName + dropOn);
            }
        }
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
        	xtype: 'pagingtoolbar',
        	store : 'coursetransaction.studentenrollment.studentenrollmentdetail.courses.OptionalCourses',
            plugins:['pagesize'],
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }]
    }],
    tbar: [{
    	xtype: 'button',
        itemId: 'optionalCoursesbtnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    },{
		xtype : 'button',				
		itemId : 'optionalCoursesbtnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
		//text : getCommonTranslation('EDIT')
	},{
		xtype : 'button',		
		text:'Student Cart',
		itemId : 'compulsoryCoursesbtnShoppingCart'
		//tooltip : 'Show Shopping Cart',
		//text : getCommonTranslation('EDIT')
	}],
    columns : [{},
      {
	    header : getCourseTxCommonTranslation('COURSES'),
	    dataIndex : 'courseName',
	    flex : .2,
	    sortable : true
	}, {
	    header : getCourseTxCommonTranslation('COURSE_VARIANT'),
	    dataIndex : 'courseVariantCode',
	   // flex : .1,
	    sortable : true
	}
	]
});